﻿---
title: System diskio metricset
description: The System diskio metricset provides disk IO metrics collected from the operating system. One event is created for each disk mounted on the system. This...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-diskio
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System diskio metricset
The System `diskio` metricset provides disk IO metrics collected from the operating system. One event is created for each disk mounted on the system.
This metricset is available on:
- Linux
- macOS (requires 10.10+)
- Windows
- FreeBSD (amd64)


## Configuration

<definitions>
  <definition term="diskio.include_devices">
    When the `diskio` metricset is enabled, you can use the `diskio.include_devices` option to define a list of device names to pre-filter the devices that are reported. Filters only exact matches. If not set or given `[]` empty array, all disk devices are returned
    The following example config returns metrics for devices matching include_devices:
    ```yaml
    metricbeat.modules:
    - module: system
      metricsets: ["diskio"]
      diskio.include_devices: ["sda", "sda1"]
    ```
  </definition>
</definitions>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.diskio",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "diskio",
        "period": 10000
    },
    "service": {
        "type": "system"
    },
    "system": {
        "diskio": {
            "io": {
                "ops": 0,
                "time": 545105
            },
            "name": "sda",
            "read": {
                "bytes": 4242313728,
                "count": 181371,
                "time": 2744086
            },
            "write": {
                "bytes": 9611375104,
                "count": 352596,
                "time": 10641320
            }
        }
    }
}
```