﻿---
title: System cpu metricset
description: The System cpu metricset provides CPU statistics. This metricset is available on: FreeBSD, Linux, macOS, OpenBSD, Windows. This is a default metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-cpu
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System cpu metricset
The System `cpu` metricset provides CPU statistics.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- OpenBSD
- Windows


## Configuration

<definitions>
  <definition term="cpu.metrics">
    This option controls what CPU metrics are reported. The value is a list and three metric types are supported - `percentages`, `normalized_percentages`, and `ticks`. The default value is `cpu.metrics: [percentages]`.
  </definition>
  <definition term="use_performance_counters">
    This option enables the use of performance counters to collect data for the CPU/core metricset. It is only effective on Windows. You should use this option if running beats on machins with more than 64 cores. The default value is `use_performance_counters: true`
    ```yaml
    metricbeat.modules:
    - module: system
      metricsets: [cpu]
      cpu.metrics: [percentages, normalized_percentages, ticks]
      #use_performance_counters: false
    ```
  </definition>
</definitions>

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.cpu",
        "duration": 115000,
        "module": "system"
    },
    "host": {
        "cpu": {
            "usage": 0.0467
        }
    },
    "metricset": {
        "name": "cpu",
        "period": 10000
    },
    "service": {
        "type": "system"
    },
    "system": {
        "cpu": {
            "cores": 24,
            "idle": {
                "norm": {
                    "pct": 0.9532
                },
                "pct": 22.8778,
                "ticks": 5843152812
            },
            "iowait": {
                "norm": {
                    "pct": 0.0001
                },
                "pct": 0.002,
                "ticks": 335866
            },
            "irq": {
                "norm": {
                    "pct": 0.0017
                },
                "pct": 0.0401,
                "ticks": 7025540
            },
            "nice": {
                "norm": {
                    "pct": 0.0003
                },
                "pct": 0.006,
                "ticks": 1812301
            },
            "softirq": {
                "norm": {
                    "pct": 0.0008
                },
                "pct": 0.02,
                "ticks": 3581641
            },
            "steal": {
                "norm": {
                    "pct": 0
                },
                "pct": 0,
                "ticks": 0
            },
            "system": {
                "norm": {
                    "pct": 0.0169
                },
                "pct": 0.4068,
                "ticks": 67901836
            },
            "total": {
                "norm": {
                    "pct": 0.0467
                },
                "pct": 1.1202
            },
            "user": {
                "norm": {
                    "pct": 0.027
                },
                "pct": 0.6472,
                "ticks": 126846063
            }
        }
    }
}
```