﻿---
title: System core metricset
description: The System core metricset provides usage statistics for each CPU core. This metricset is available on: FreeBSD, Linux, macOS, OpenBSD, Windows. For a...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-system-core
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# System core metricset
The System `core` metricset provides usage statistics for each CPU core.
This metricset is available on:
- FreeBSD
- Linux
- macOS
- OpenBSD
- Windows


## Configuration

<definitions>
  <definition term="core.metrics">
    This option controls what metrics are reported for each CPU core. The value is a list and two metric types are supported - `percentages` and `ticks`. The default value is `core.metrics: [percentages]`.
  </definition>
  <definition term="use_performance_counters">
    This option enables the use of performance counters to collect data for the CPU/core metricset. It is only effective on Windows. You should use this option if running beats on machins with more than 64 cores. The default value is `use_performance_counters: true`
    ```yaml
    metricbeat.modules:
    - module: system
      metricsets: [core]
      core.metrics: [percentages, ticks]
      #use_performance_counters: false
    ```
  </definition>
</definitions>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-system) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "system.core",
        "duration": 115000,
        "module": "system"
    },
    "metricset": {
        "name": "core",
        "period": 10000
    },
    "service": {
        "type": "system"
    },
    "system": {
        "core": {
            "id": 0,
            "idle": {
                "pct": 0.9638,
                "ticks": 240932600
            },
            "iowait": {
                "pct": 0,
                "ticks": 10534
            },
            "irq": {
                "pct": 0.002,
                "ticks": 379774
            },
            "nice": {
                "pct": 0.002,
                "ticks": 70354
            },
            "softirq": {
                "pct": 0.002,
                "ticks": 498856
            },
            "steal": {
                "pct": 0,
                "ticks": 0
            },
            "system": {
                "pct": 0.0201,
                "ticks": 4072735
            },
            "total": {
                "pct": 0.0362
            },
            "user": {
                "pct": 0.0101,
                "ticks": 7020807
            }
            "model_number": "165",
            "model_name": "Intel(R) Core(TM) i9-10885H CPU @ 2.40GHz",
            "mhz": 4359.983,
            "core_id": 5,
            "physical_id": 0,
        }
    }
}
```