﻿---
title: SyncGateway resources metricset
description: SyncGateway resources metriset contains about the global resource utilization of the SyncGateway instance. This is a default metricset. If the host module...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-syncgateway-resources
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# SyncGateway resources metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

SyncGateway `resources` metriset contains about the global resource utilization of the SyncGateway instance.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-syncgateway) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "syncgateway.resources",
        "duration": 115000,
        "module": "syncgateway"
    },
    "metricset": {
        "name": "resources",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:37571",
        "type": "syncgateway"
    },
    "syncgateway": {
        "resources": {
            "admin_net_bytes": {
                "recv": 186313933,
                "sent": 67278955
            },
            "error_count": 0,
            "go_memstats": {
                "heap": {
                    "alloc": 143386592,
                    "idle": 81616896,
                    "inuse": 250585088,
                    "released": 26927104
                },
                "pause": {
                    "ns": 88693194
                },
                "stack": {
                    "inuse": 3342336,
                    "sys": 3342336
                },
                "sys": 357708024
            },
            "goroutines_high_watermark": 311,
            "num_goroutines": 308,
            "process": {
                "cpu_percent_utilization": 0,
                "memory_resident": 335306752
            },
            "pub_net": {
                "recv": {
                    "bytes": 186313933
                },
                "sent": {
                    "bytes": 67278955
                }
            },
            "system_memory_total": 33291907072,
            "warn_count": 6
        }
    }
}
```