﻿---
title: SQL query metricset
description: The sql query metricset collects rows returned by a query. Field names (columns) are returned as lowercase strings. Values are returned as numeric or...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-sql-query
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# SQL query metricset
The sql `query` metricset collects rows returned by a query.
Field names (columns) are returned as lowercase strings. Values are returned as numeric or string.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-sql) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "sql.query",
        "duration": 115000,
        "module": "sql"
    },
    "metricset": {
        "name": "query",
        "period": 10000
    },
    "service": {
        "address": "localhost:65194",
        "type": "sql"
    },
    "sql": {
        "driver": "mysql",
        "metrics": {
            "engine": "InnoDB",
            "table_name": "db",
            "table_rows": 2,
            "table_schema": "mysql"
        },
        "query": "select table_schema, table_name, engine, table_rows from information_schema.tables where table_rows \u003e 0;"
    }
}
```