﻿---
title: Redis keyspace metricset
description: The Redis keyspace metricset collects information about the Redis keyspaces. For each keyspace, an event is sent to Elasticsearch. The keyspace information...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-redis-keyspace
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Redis keyspace metricset
The Redis `keyspace` metricset collects information about the Redis keyspaces. For each keyspace, an event is sent to Elasticsearch. The keyspace information is fetched from the [`INFO`](http://redis.io/commands/INFO) command.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-redis) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "redis.keyspace",
        "duration": 115000,
        "module": "redis"
    },
    "metricset": {
        "name": "keyspace"
    },
    "redis": {
        "keyspace": {
            "avg_ttl": 359459,
            "expires": 0,
            "id": "db0",
            "keys": 1
        }
    },
    "service": {
        "address": "127.0.0.1:6379",
        "type": "redis"
    }
}
```