﻿---
title: Redis info metricset
description: The Redis info metricset collects information and statistics from Redis by running the INFO command and parsing the returned result. This is a default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-redis-info
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Redis info metricset
The Redis `info` metricset collects information and statistics from Redis by running the [`INFO`](http://redis.io/commands/INFO) command and parsing the returned result.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-redis) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "redis.info",
        "duration": 115000,
        "module": "redis"
    },
    "metricset": {
        "name": "info",
        "period": 10000
    },
    "os": {
        "full": "Linux 5.10.47-linuxkit x86_64"
    },
    "process": {
        "pid": 1
    },
    "redis": {
        "info": {
            "clients": {
                "blocked": 0,
                "connected": 2,
                "max_input_buffer": 0,
                "max_output_buffer": 0
            },
            "cluster": {
                "enabled": false
            },
            "commandstats": {
                "info": {
                    "calls": 3,
                    "usec": 241,
                    "usec_per_call": 80.33
                },
                "slowlog": {
                    "calls": 3,
                    "usec": 22,
                    "usec_per_call": 7.33
                }
            },
            "cpu": {
                "used": {
                    "sys": 0.85,
                    "sys_children": 0,
                    "user": 0.14,
                    "user_children": 0
                }
            },
            "memory": {
                "active_defrag": {},
                "allocator": "jemalloc-4.0.3",
                "allocator_stats": {
                    "fragmentation": {},
                    "rss": {}
                },
                "fragmentation": {
                    "ratio": 2.74
                },
                "max": {
                    "policy": "noeviction",
                    "value": 0
                },
                "used": {
                    "lua": 37888,
                    "peak": 843312,
                    "rss": 2310144,
                    "value": 843312
                }
            },
            "persistence": {
                "aof": {
                    "bgrewrite": {
                        "last_status": "ok"
                    },
                    "buffer": {},
                    "copy_on_write": {},
                    "enabled": false,
                    "fsync": {},
                    "rewrite": {
                        "buffer": {},
                        "current_time": {
                            "sec": -1
                        },
                        "in_progress": false,
                        "last_time": {
                            "sec": -1
                        },
                        "scheduled": false
                    },
                    "size": {},
                    "write": {
                        "last_status": "ok"
                    }
                },
                "loading": false,
                "rdb": {
                    "bgsave": {
                        "current_time": {
                            "sec": -1
                        },
                        "in_progress": false,
                        "last_status": "ok",
                        "last_time": {
                            "sec": -1
                        }
                    },
                    "copy_on_write": {},
                    "last_save": {
                        "changes_since": 0,
                        "time": 1642155583
                    }
                }
            },
            "replication": {
                "backlog": {
                    "active": 0,
                    "first_byte_offset": 0,
                    "histlen": 0,
                    "size": 1048576
                },
                "connected_slaves": 0,
                "master": {
                    "offset": 0,
                    "sync": {}
                },
                "role": "master",
                "slave": {}
            },
            "server": {
                "arch_bits": "64",
                "build_id": "b9a4cd86ce8027d3",
                "config_file": "",
                "gcc_version": "6.4.0",
                "git_dirty": "0",
                "git_sha1": "00000000",
                "hz": 10,
                "lru_clock": 14765805,
                "mode": "standalone",
                "multiplexing_api": "epoll",
                "run_id": "567ea825bae461f81d687f671c6cfaef5c1e45c7",
                "tcp_port": 6379,
                "uptime": 174
            },
            "slowlog": {
                "count": 0
            },
            "stats": {
                "active_defrag": {},
                "commands_processed": 6,
                "connections": {
                    "received": 164,
                    "rejected": 0
                },
                "instantaneous": {
                    "input_kbps": 0,
                    "ops_per_sec": 0,
                    "output_kbps": 0
                },
                "keys": {
                    "evicted": 0,
                    "expired": 0
                },
                "keyspace": {
                    "hits": 0,
                    "misses": 0
                },
                "latest_fork_usec": 0,
                "migrate_cached_sockets": 0,
                "net": {
                    "input": {
                        "bytes": 170
                    },
                    "output": {
                        "bytes": 6593
                    }
                },
                "pubsub": {
                    "channels": 0,
                    "patterns": 0
                },
                "sync": {
                    "full": 0,
                    "partial": {
                        "err": 0,
                        "ok": 0
                    }
                }
            }
        }
    },
    "service": {
        "address": "localhost:63118",
        "type": "redis",
        "version": "3.2.12"
    }
}
```