﻿---
title: RabbitMQ queue metricset
description: This is the queue metricset of the module rabbitmq. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-queue
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# RabbitMQ queue metricset
This is the queue metricset of the module rabbitmq.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-rabbitmq) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "event": {
        "dataset": "rabbitmq.queue",
        "duration": 115000,
        "module": "rabbitmq"
    },
    "metricset": {
        "name": "queue"
    },
    "rabbitmq": {
        "node": {
            "name": "rabbit@localhost"
        },
        "queue": {
            "arguments": {
                "max_priority": 9
            },
            "auto_delete": false,
            "consumers": {
                "count": 3,
                "utilisation": {
                    "pct": 0.7
                }
            },
            "disk": {
                "reads": {
                    "count": 212
                },
                "writes": {
                    "count": 121
                }
            },
            "durable": true,
            "exclusive": false,
            "memory": {
                "bytes": 232720
            },
            "messages": {
                "persistent": {
                    "count": 73
                },
                "ready": {
                    "count": 71,
                    "details": {
                        "rate": 0
                    }
                },
                "total": {
                    "count": 74,
                    "details": {
                        "rate": 2.2
                    }
                },
                "unacknowledged": {
                    "count": 3,
                    "details": {
                        "rate": 0.5
                    }
                }
            },
            "name": "queuenamehere",
            "state": "running"
        },
        "vhost": "/"
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "rabbitmq"
    }
}
```