﻿---
title: RabbitMQ node metricset
description: This is the node metricset of the RabbitMQ module and collects metrics about RabbitMQ nodes. The metricset has two modes to collect data which can be...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-node
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# RabbitMQ node metricset
This is the `node` metricset of the RabbitMQ module and collects metrics about RabbitMQ nodes.
The metricset has two modes to collect data which can be selected with the `node.collect` setting:
- `node`: collects metrics only from the node `metricbeat` connects to. This is the default, as it is recommended to deploy `metricbeat` in all nodes.
- `cluster`: collects metrics from all the nodes in the cluster. This is recommended when collecting metrics of an only endpoint for the whole cluster.

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-rabbitmq) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "rabbitmq.node",
        "duration": 115000,
        "module": "rabbitmq"
    },
    "metricset": {
        "name": "node"
    },
    "rabbitmq": {
        "node": {
            "disk": {
                "free": {
                    "bytes": 485213712384,
                    "limit": {
                        "bytes": 50000000
                    }
                }
            },
            "fd": {
                "total": 1048576,
                "used": 54
            },
            "gc": {
                "num": {
                    "count": 5724
                },
                "reclaimed": {
                    "bytes": 294021640
                }
            },
            "io": {
                "file_handle": {
                    "open_attempt": {
                        "avg": {
                            "ms": 0
                        },
                        "count": 10
                    }
                },
                "read": {
                    "avg": {
                        "ms": 0
                    },
                    "bytes": 1,
                    "count": 1
                },
                "reopen": {
                    "count": 1
                },
                "seek": {
                    "avg": {
                        "ms": 0
                    },
                    "count": 0
                },
                "sync": {
                    "avg": {
                        "ms": 0
                    },
                    "count": 0
                },
                "write": {
                    "avg": {
                        "ms": 0
                    },
                    "bytes": 0,
                    "count": 0
                }
            },
            "mem": {
                "limit": {
                    "bytes": 13340778496
                },
                "used": {
                    "bytes": 71448312
                }
            },
            "mnesia": {
                "disk": {
                    "tx": {
                        "count": 0
                    }
                },
                "ram": {
                    "tx": {
                        "count": 43
                    }
                }
            },
            "msg": {
                "store_read": {
                    "count": 0
                },
                "store_write": {
                    "count": 0
                }
            },
            "name": "rabbit@my-rabbit",
            "proc": {
                "total": 1048576,
                "used": 234
            },
            "processors": 12,
            "queue": {
                "index": {
                    "journal_write": {
                        "count": 0
                    },
                    "read": {
                        "count": 0
                    },
                    "write": {
                        "count": 0
                    }
                }
            },
            "run": {
                "queue": 0
            },
            "socket": {
                "total": 943626,
                "used": 0
            },
            "type": "disc",
            "uptime": 155275
        }
    },
    "service": {
        "address": "172.17.0.2:15672",
        "type": "rabbitmq"
    }
}
```