﻿---
title: RabbitMQ connection metricset
description: This is the connection metricset of the RabbitMQ module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-rabbitmq-connection
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# RabbitMQ connection metricset
This is the `connection` metricset of the RabbitMQ module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-rabbitmq) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "event": {
        "dataset": "rabbitmq.connection",
        "duration": 115000,
        "module": "rabbitmq"
    },
    "metricset": {
        "name": "connection",
        "period": 10000
    },
    "rabbitmq": {
        "connection": {
            "channel_max": 65535,
            "channels": 2,
            "client_provided": {
                "name": "Connection2"
            },
            "frame_max": 131072,
            "host": "::1",
            "name": "[::1]:60940 -\u003e [::1]:5672",
            "octet_count": {
                "received": 3057,
                "sent": 3344
            },
            "packet_count": {
                "pending": 0,
                "received": 352,
                "sent": 352
            },
            "peer": {
                "host": "::1",
                "port": 60940
            },
            "port": 5672,
            "state": "running",
            "type": "network"
        },
        "node": {
            "name": "nodename"
        },
        "vhost": "/"
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "rabbitmq"
    },
    "user": {
        "name": "guest"
    }
}
```