﻿---
title: Oracle tablespace metricset
description: tablespace Metricset includes information about data files and temp files, grouped by Tablespace with free space available, used space, status of the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-oracle-tablespace
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Oracle tablespace metricset
`tablespace` Metricset includes information about data files and temp files, grouped by Tablespace with free space available, used space, status of the data files, status of the Tablespace, etc.

## Required database access

To ensure that the module has access to the appropriate metrics, the module requires that you configure a user with access to the following tables:
- SYS.DBA_TEMP_FILES
- DBA_TEMP_FREE_SPACE
- dba_data_files
- dba_free_space


## Description of fields

- **data_file.id**: Tablespace data file unique identifier number. Each data file of a Tablespace has a unique name (and each Tablespace may have more than one data file) but this is not the Tablespace ID.
- **data_file.name**: Filename of the data file (with the full path)
- **data_file.online_status**: Last known online status of the data file. One of SYSOFF, SYSTEM, OFFLINE, ONLINE or RECOVER.
- **data_file.size.bytes**: Size of the file in bytes.
- **data_file.size.free.bytes**: The size of the file available for user data. The actual size of the file minus this value is used to store file related metadata.
- **data_file.size.max.bytes**: Maximum file size in bytes
- **data_file.status**: File status: AVAILABLE or INVALID (INVALID means that the file number is not in use, for example, a file in a tablespace that was dropped)
- **name**: Tablespace name
- **space.free.bytes**: Tablespace total free space available, in bytes.
- **space.total.bytes**: Tablespace total size, in bytes. Calculated by adding the file sizes for each Tablespace.
- **space.used.bytes**: Tablespace used space, in bytes.


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-oracle) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "oracle.tablespace",
        "duration": 115000,
        "module": "oracle"
    },
    "metricset": {
        "name": "tablespace",
        "period": 10000
    },
    "oracle": {
        "tablespace": {
            "data_file": {
                "id": 3,
                "name": "/u02/app/oracle/oradata/ORCL/sysaux01.dbf",
                "online_status": "ONLINE",
                "size": {
                    "bytes": 744488960,
                    "free": {
                        "bytes": 743440384
                    },
                    "max": {
                        "bytes": 34359721984
                    }
                },
                "status": "AVAILABLE"
            },
            "name": "SYSAUX",
            "space": {
                "free": {
                    "bytes": 39124992
                },
                "used": {
                    "bytes": 744488960
                }
            }
        }
    },
    "service": {
        "address": "localhost:32769",
        "type": "oracle"
    }
}
```