﻿---
title: Openmetrics collector metricset
description: This is the collector metricset of the Openmetrics module. It collects metrics from endpoints that follow Openmetrics format. This is a default metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-openmetrics-collector
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Openmetrics collector metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the `collector` metricset of the Openmetrics module. It collects metrics from endpoints that follow Openmetrics format.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-openmetrics) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "event": {
        "dataset": "openmetrics.collector",
        "duration": 115000,
        "module": "openmetrics"
    },
    "metricset": {
        "name": "collector",
        "period": 10000
    },
    "openmetrics": {
        "help": "Total number of connections closed that were made to the listener of a given name.",
        "labels": {
            "job": "openmetrics",
            "listener_name": "http"
        },
        "metrics": {
            "net_conntrack_listener_conn_closed_total": 0
        },
        "type": "counter"
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "openmetrics"
    }
}
```