﻿---
title: Nginx stubstatus metricset
description: The Nginx stubstatus metricset collects data from the Nginx ngx_http_stub_status module. It scrapes the server status data from the web page generated...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nginx-stubstatus
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Nginx stubstatus metricset
The Nginx `stubstatus` metricset collects data from the Nginx [ngx_http_stub_status](http://nginx.org/en/docs/http/ngx_http_stub_status_module.html) module. It scrapes the server status data from the web page generated by ngx_http_stub_status.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-nginx) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "nginx.stubstatus",
        "duration": 115000,
        "module": "nginx"
    },
    "metricset": {
        "name": "stubstatus"
    },
    "nginx": {
        "stubstatus": {
            "accepts": 6254,
            "active": 2,
            "current": 1,
            "dropped": 0,
            "handled": 6254,
            "hostname": "127.0.0.1",
            "reading": 0,
            "requests": 6259,
            "waiting": 1,
            "writing": 1
        }
    },
    "service": {
        "address": "127.0.0.1",
        "type": "nginx"
    }
}
```