﻿---
title: NATS jetstream metricset
description: This is the JetStream metricset of the NATS module. It supports gathering basic stats about a JetStream server as well as specific details about streams...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-nats-jetstream
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta since 9.1
---

# NATS jetstream metricset
This is the JetStream metricset of the NATS module. It supports gathering basic stats about a JetStream server as well as specific details about streams and consumers.
The data is pulled from the [/jsz](https://docs.nats.io/running-a-nats-service/nats_admin/monitoring#jetstream-information-jsz) API of a JetStream server.

## Configuration

You can enable each of the specific data points via configuration for the `jetstream` metricset. For example:
```yaml
jetstream:
  stats:
    # Enables basic stats collection about the JetStream server
    enabled: true
  account:
    # Enables data collection about accounts on the server 
    enabled: true
  stream:
    # Enables data collection about streams on the server 
    enabled: true
  consumer:
    # Enables data collection about consumers on the server 
    enabled: true
```

You can also filter account, stream, and consumer metrics by name:
```yaml
jetstream:
  account:
    names:
      - default
      - another account
  stream:
    names:
      - my-stream-1
      - my-stream-2
  consumer:
    names:
      - my-stream-1-consumer-1
      - my-stream-1-consumer-2
```

Since this data is hierarchical, these filters are cumulative and apply even if the particular data set is not enabled but filters are configured. When there are no names configured, all information about all accounts, streams, and consumers will be reported.

## Sample event

This section contains some example events generated by the JetStream metricset.

### Stats

The `stats` option will produce events that include basic, high-level stats about your JetStream server.
Example:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "nats.jetstream",
        "duration": 115000,
        "module": "nats"
    },
    "metricset": {
        "name": "jetstream",
        "period": 10000
    },
    "nats": {
        "jetstream": {
            "category": "stats",
            "stats": {
                "accounts": 1,
                "bytes": 17395590,
                "config": {
                    "max_memory": 12427170816,
                    "max_storage": 752333079552,
                    "store_dir": "/tmp/nats/jetstream",
                    "sync_interval": 120000000000
                },
                "consumers": 0,
                "memory": 0,
                "messages": 102327,
                "reserved_memory": 0,
                "reserved_storage": 1073741824,
                "storage": 17395590,
                "streams": 1
            }
        },
        "server": {
            "id": "NBUWPVHICBBDHQZ3OPY2AEAVJVHDOQEVIQND3RLRUMCIZZEKHXHX5GDW",
            "time": "2025-03-16T15:24:47.293Z"
        }
    },
    "service": {
        "address": "localhost:60829",
        "type": "nats"
    }
}
```


### Account

The `account` option will produce events containing information about accounts on the JetStream server.
Example:
```json
{
    "event": {
        "dataset": "nats.jetstream",
        "duration": 115000,
        "module": "nats"
    },
    "metricset": {
        "name": "jetstream",
        "period": 10000
    },
    "nats": {
        "jetstream": {
            "account": {
                "accounts": 0,
                "api": {
                    "errors": 22596,
                    "total": 1436563
                },
                "high_availability_assets": 0,
                "id": "default",
                "memory": 2408,
                "name": "default",
                "reserved_memory": 8589934592,
                "reserved_storage": 429496729600,
                "storage": 1474866157
            },
            "category": "account"
        },
        "server": {
            "id": "NAGGEW65XCMGPSNNQQF6FGKDGQCCXZFMHDI264FXBLT5MURRVDAAKII3",
            "time": "2025-03-15T01:22:56.617Z"
        }
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "nats"
    }
}
```


### Stream

The `stream` option will produce events containing information about streams on the JetStream server.
Example:
```json
{
    "event": {
        "dataset": "nats.jetstream",
        "duration": 115000,
        "module": "nats"
    },
    "metricset": {
        "name": "jetstream",
        "period": 10000
    },
    "nats": {
        "jetstream": {
            "category": "stream",
            "stream": {
                "account": {
                    "id": "default",
                    "name": "default"
                },
                "cluster": {
                    "leader": "us-south-nats-demo"
                },
                "config": {
                    "description": "",
                    "max_age": 0,
                    "max_bytes": -1,
                    "max_consumers": -1,
                    "max_msg_size": -1,
                    "max_msgs": -1,
                    "max_msgs_per_subject": 10,
                    "num_replicas": 1,
                    "retention": "limits",
                    "storage": "file",
                    "subjects": [
                        "$KV.credibil-wallet-8f580625-2ccf-494e-a5e7-44f9335c801f.\u003e"
                    ]
                },
                "created": "2024-07-17T23:54:45.971Z",
                "name": "KV_credibil-wallet-8f580625-2ccf-494e-a5e7-44f9335c801f",
                "state": {
                    "bytes": 3353,
                    "consumer_count": 0,
                    "first_seq": 1,
                    "first_ts": "2024-07-17T23:54:46.152Z",
                    "last_seq": 2,
                    "last_ts": "2024-07-17T23:54:46.870Z",
                    "messages": 2,
                    "num_deleted": 0,
                    "num_subjects": 1
                }
            }
        },
        "server": {
            "id": "NAGGEW65XCMGPSNNQQF6FGKDGQCCXZFMHDI264FXBLT5MURRVDAAKII3",
            "time": "2025-03-15T11:54:13.510Z"
        }
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "nats"
    }
}
```


### Consumer

The `consumer` option will produce events containing information about consumers on the JetStream server.
Example:
```json
{
    "event": {
        "dataset": "nats.jetstream",
        "duration": 115000,
        "module": "nats"
    },
    "metricset": {
        "name": "jetstream",
        "period": 10000
    },
    "nats": {
        "jetstream": {
            "category": "consumer",
            "consumer": {
                "account": {
                    "id": "default",
                    "name": "default"
                },
                "ack_floor": {
                    "consumer_seq": 0,
                    "last_active": "0001-01-01T00:00:00.000Z",
                    "stream_seq": 0
                },
                "cluster": {
                    "leader": "us-south-nats-demo"
                },
                "config": {
                    "ack_policy": "explicit",
                    "ack_wait": 300000,
                    "deliver_policy": "all",
                    "durable_name": "cyco-activity-dani-cve_data",
                    "filter_subject": "cve_data",
                    "max_ack_pending": 1000,
                    "max_deliver": -1,
                    "max_waiting": 512,
                    "name": "cyco-activity-dani-cve_data",
                    "num_replicas": 0,
                    "replay_policy": "original"
                },
                "created": "2025-03-10T12:57:13.976Z",
                "delivered": {
                    "consumer_seq": 0,
                    "last_active": "0001-01-01T00:00:00.000Z",
                    "stream_seq": 0
                },
                "last_active_time": "2025-03-15T12:37:22.942Z",
                "name": "cyco-activity-dani-cve_data",
                "num_ack_pending": 0,
                "num_pending": 0,
                "num_redelivered": 0,
                "num_waiting": 0,
                "stream": {
                    "name": "cve_importer"
                }
            }
        },
        "server": {
            "id": "NAGGEW65XCMGPSNNQQF6FGKDGQCCXZFMHDI264FXBLT5MURRVDAAKII3",
            "time": "2025-03-15T12:37:22.942Z"
        }
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "nats"
    }
}
```

Note: `consumer` data is only available in JetStream versions 2.9+.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-nats) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "nats.jetstream",
        "duration": 115000,
        "module": "nats"
    },
    "metricset": {
        "name": "jetstream",
        "period": 10000
    },
    "nats": {
        "jetstream": {
            "category": "stats",
            "stats": {
                "accounts": 1,
                "bytes": 17395590,
                "config": {
                    "max_memory": 12427170816,
                    "max_storage": 752333079552,
                    "store_dir": "/tmp/nats/jetstream",
                    "sync_interval": 120000000000
                },
                "consumers": 0,
                "memory": 0,
                "messages": 102327,
                "reserved_memory": 0,
                "reserved_storage": 1073741824,
                "storage": 17395590,
                "streams": 1
            }
        },
        "server": {
            "id": "NBUWPVHICBBDHQZ3OPY2AEAVJVHDOQEVIQND3RLRUMCIZZEKHXHX5GDW",
            "time": "2025-03-16T15:24:47.293Z"
        }
    },
    "service": {
        "address": "localhost:60829",
        "type": "nats"
    }
}
```