﻿---
title: MySQL status metricset
description: The MySQL status metricset collects data from MySQL by running a SHOW GLOBAL STATUS; SQL query. This query returns a large number of metrics. The MySQL...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mysql-status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MySQL status metricset
The MySQL `status` metricset collects data from MySQL by running a [`SHOW GLOBAL STATUS;`](http://dev.mysql.com/doc/refman/5.7/en/show-status.md) SQL query. This query returns a large number of metrics.

## raw config option

<warning>
  This functionality is in technical preview and may be changed or removed in a future release. Elastic will work to fix any issues, but features in technical preview are not subject to the support SLA of official GA features.
</warning>

The MySQL Status Metricset supports the `raw` config option. When enabled, in addition to the existing data structure, all fields available from the mysql service through `"SHOW /*!50002 GLOBAL */ STATUS;"` will be added to the event.
These fields will be added under the namespace `mysql.status.raw`. The fields can vary from one MySQL instance to an other and no guarantees are provided for the  mapping of the fields as the mapping happens dynamically. This option is intended for advanced use cases.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mysql) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2020-07-13T16:36:00.626Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "agent": {
        "version": "8.0.0",
        "ephemeral_id": "d9d0d455-c440-453e-aea3-3b6fa512f6f3",
        "id": "803dfdba-e638-4590-a2de-80cb1cebe78d",
        "name": "mcastro",
        "type": "metricbeat"
    },
    "mysql": {
        "status": {
            "connections": 28,
            "threads": {
                "running": 2,
                "cached": 1,
                "created": 4,
                "connected": 3
            },
            "innodb": {
                "rows": {
                    "updated": 0,
                    "deleted": 0,
                    "inserted": 0,
                    "reads": 0
                },
                "buffer_pool": {
                    "write_requests": 1634,
                    "bytes": {
                        "data": 15908864,
                        "dirty": 0
                    },
                    "pages": {
                        "data": 971,
                        "dirty": 0,
                        "flushed": 144,
                        "free": 7216,
                        "misc": 5,
                        "total": 8192
                    },
                    "read": {
                        "requests": 15600,
                        "ahead": 0,
                        "ahead_evicted": 0,
                        "ahead_rnd": 0
                    },
                    "pool": {
                        "reads": 830,
                        "wait_free": 0
                    }
                }
            },
            "handler": {
                "update": 315,
                "read": {
                    "rnd_next": 394983,
                    "first": 33,
                    "key": 2100,
                    "last": 0,
                    "next": 4533,
                    "prev": 0,
                    "rnd": 2494
                },
                "write": 168505,
                "mrr_init": 0,
                "delete": 0,
                "external_lock": 8167,
                "savepoint_rollback": 0,
                "rollback": 0,
                "commit": 625,
                "savepoint": 0,
                "prepare": 0
            },
            "bytes": {
                "sent": 6228481,
                "received": 143324
            },
            "created": {
                "tmp": {
                    "tables": 364,
                    "disk_tables": 0,
                    "files": 5
                }
            },
            "binlog": {
                "cache": {
                    "disk_use": 0,
                    "use": 0
                }
            },
            "connection": {
                "errors": {
                    "max": 0,
                    "peer_address": 0,
                    "select": 0,
                    "tcpwrap": 0,
                    "accept": 0,
                    "internal": 0
                }
            },
            "delayed": {
                "errors": 0,
                "insert_threads": 0,
                "writes": 0
            },
            "max_used_connections": 4,
            "opened_tables": 195,
            "queries": 1183,
            "flush_commands": 3,
            "command": {
                "insert": 0,
                "select": 705,
                "update": 0,
                "delete": 0
            },
            "aborted": {
                "clients": 0,
                "connects": 2
            },
            "cache": {
                "table": {
                    "open_cache": {
                        "hits": 3889,
                        "misses": 195,
                        "overflows": 0
                    }
                },
                "ssl": {
                    "size": 128,
                    "hits": 0,
                    "misses": 0
                }
            },
            "questions": 1173,
            "open": {
                "streams": 0,
                "tables": 116,
                "files": 2
            }
        }
    },
    "event": {
        "dataset": "mysql.status",
        "module": "mysql",
        "duration": 1871014
    },
    "metricset": {
        "name": "status",
        "period": 10000
    },
    "service": {
        "address": "172.17.0.2:3306",
        "type": "mysql"
    },
    "ecs": {
        "version": "1.5.0"
    },
    "host": {
        "name": "mcastro"
    }
}
```