﻿---
title: MySQL galera_status metricset
description: This module periodically fetches metrics from Galera-MySQL cluster servers. When configuring the hosts option, you must use a MySQL Data Source Name (DSN)...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mysql-galera_status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# MySQL galera_status metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This module periodically fetches metrics from [Galera](http://galeracluster.com/)-MySQL cluster servers.

## Module-specific configuration notes

When configuring the `hosts` option, you must use a MySQL Data Source Name (DSN) of the following format:
```
[username[:password]@][protocol[(address)]]/
```

You can also separately specify the username and password using the respective configuration options. Usernames and passwords specified in the DSN take precedence over those specified in the `username` and `password` config options.
```
- module: mysql
  metricsets: ["status"]
  hosts: ["tcp(127.0.0.1:3306)/"]
  username: root
  password: secret
```


## Compatibility

The galera MetricSets were tested with galera 3.22 (MySQL 5.7.20) and are expected to work with all versions >= 3.0 (MySQL >= 5.7.0)

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mysql) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp":"2016-05-23T08:05:34.853Z",
    "beat":{
        "hostname":"host.example.com",
        "name":"host.example.com"
    },
    "metricset":{
        "host":"localhost:3306",
        "module":"mysql",
        "name":"galera_status",
        "rtt":44269
    },
    "mysql":{
        "galera_status":{
            "apply": {
                "oooe": 0,
                "oool": 0,
                "window": 1
            },
            "connected": "ON",
            "flow_ctl": {
                "recv": 0,
                "sent": 0,
                "paused": 0,
                "paused_ns": 0
            },
            "ready": "ON",
            "received": {
                "count": 173,
                "bytes": 152425
            },
            "local": {
                "state": "Synced",
                "bf_aborts": 0,
                "cert_failures": 0,
                "commits": 1325,
                "recv": {
                    "queue_max": 2,
                    "queue_min": 0,
                    "queue": 0,
                    "queue_avg": 0.011561
                },
                "replays": 0,
                "send": {
                    "queue_min": 0,
                    "queue": 0,
                    "queue_avg": 0,
                    "queue_max": 1
                }
            },
            "evs": {
                "evict": "",
                "state": "OPERATIONAL"
            },
            "repl": {
                "bytes": 1689804,
                "data_bytes": 1540647,
                "keys": 4170,
                "keys_bytes": 63973,
                "other_bytes": 0,
                "count": 1331
            },
            "commit": {
                "oooe": 0,
                "window": 1
            },
            "cluster": {
                "conf_id": 930,
                "size": 3,
                "status": "Primary"
            },
            "last_committed": 23944,
            "cert": {
                "deps_distance": 43.524557,
                "index_size": 22,
                "interval": 0
            }
        }
    },
    "type":"metricsets"
}
```