﻿---
title: Munin node metricset
description: This is the node metricset of the module munin. The node metricset of the munin module collects metrics from a munin node agent and sends them as events...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-munin-node
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Munin node metricset
This is the node metricset of the module munin.

## Features and configuration

The node metricset of the munin module collects metrics from a munin node agent and sends them as events to Elastic.
```yaml
```

Metrics exposed by a single munin node will be sent in an event per plugin.
For example with the previous configuration two events are sent like the following ones.
```json
---
"munin": {
  "plugin": {
    "name": "swap"
  },
  "metrics": {
    "swap_in": 198609,
    "swap_out": 612629
  }
}
```

"munin": { "plugin": { "name": "cpu" } "metrics": { "softirq": 680, "guest": 0, "user": 158212, "iowait": 71095, "irq": 1, "system": 35906, "idle": 1185709, "steal": 0, "nice": 1633 } } ---
In principle this module can be used to collect metrics from any agent that implements the munin node protocol ([http://guide.munin-monitoring.org/en/latest/master/network-protocol.html](http://guide.munin-monitoring.org/en/latest/master/network-protocol.html)).

## Limitations

Currently this module only collects metrics using the basic protocol. It doesn’t support capabilities or automatic dashboards generation based on munin configuration.

## Exposed fields, dashboards, indexes, etc.

Munin supports a great variety of plugins each of them can be used to obtain different sets of metrics. Metricbeat cannot know the metrics exposed beforehand, so no field description or dashboard is generated automatically.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-munin) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "munin.node",
        "duration": 115000,
        "module": "munin"
    },
    "metricset": {
        "name": "node"
    },
    "munin": {
        "metrics": {
            "guest": 0,
            "idle": 6999219,
            "iowait": 5441,
            "irq": 0,
            "nice": 0,
            "softirq": 6419,
            "steal": 0,
            "system": 374903,
            "user": 486780
        },
        "plugin": {
            "name": "cpu"
        }
    },
    "service": {
        "address": "127.0.0.1:4949",
        "type": "cpu"
    }
}
```