﻿---
title: MongoDB status metricset
description: This is the status metricset of the MongoDB module. It requires the following privileges, which is covered by the clusterMonitor role: serverStatus action...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mongodb-status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MongoDB status metricset
This is the `status` metricset of the MongoDB module.
It requires the following privileges, which is covered by the [`clusterMonitor` role](https://docs.mongodb.com/manual/reference/built-in-roles/#clusterMonitor):
- [`serverStatus` action](https://docs.mongodb.com/manual/reference/privilege-actions/#serverStatus) on [`cluster` resource](https://docs.mongodb.com/manual/reference/resource-document/#cluster-resource)

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mongodb) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "mongodb.status",
        "duration": 115000,
        "module": "mongodb"
    },
    "metricset": {
        "name": "status",
        "period": 10000
    },
    "mongodb": {
        "status": {
            "asserts": {
                "msg": 0,
                "regular": 0,
                "rollovers": 0,
                "user": 5,
                "warning": 0
            },
            "connections": {
                "available": 815,
                "current": 4,
                "total_created": 783
            },
            "extra_info": {
                "heap_usage": {},
                "page_faults": 14
            },
            "global_lock": {
                "active_clients": {
                    "readers": 0,
                    "total": 18,
                    "writers": 0
                },
                "current_queue": {
                    "readers": 0,
                    "total": 0,
                    "writers": 0
                },
                "total_time": {
                    "us": 793189000
                }
            },
            "local_time": "2022-05-07T12:34:04.274Z",
            "locks": {
                "collection": {
                    "acquire": {
                        "count": {
                            "W": 1,
                            "r": 2741
                        }
                    },
                    "deadlock": {},
                    "wait": {}
                },
                "database": {
                    "acquire": {
                        "count": {
                            "R": 2,
                            "W": 16,
                            "r": 3707,
                            "w": 1
                        }
                    },
                    "deadlock": {},
                    "wait": {}
                },
                "global": {
                    "acquire": {
                        "count": {
                            "W": 2,
                            "r": 7453,
                            "w": 17
                        }
                    },
                    "deadlock": {},
                    "wait": {}
                },
                "meta_data": {
                    "acquire": {
                        "count": {
                            "w": 1
                        }
                    },
                    "deadlock": {},
                    "wait": {}
                },
                "oplog": {
                    "acquire": {
                        "count": {
                            "r": 966,
                            "w": 1
                        }
                    },
                    "deadlock": {},
                    "wait": {}
                }
            },
            "memory": {
                "bits": 64,
                "mapped": {
                    "mb": 0
                },
                "mapped_with_journal": {
                    "mb": 0
                },
                "resident": {
                    "mb": 66
                },
                "virtual": {
                    "mb": 1183
                }
            },
            "network": {
                "in": {
                    "bytes": 7845
                },
                "out": {
                    "bytes": 204883
                },
                "requests": 93
            },
            "ops": {
                "counters": {
                    "command": 48,
                    "delete": 0,
                    "getmore": 0,
                    "insert": 0,
                    "query": 1,
                    "update": 0
                },
                "latencies": {
                    "commands": {
                        "count": 48,
                        "latency": 43041525
                    },
                    "reads": {
                        "count": 0,
                        "latency": 0
                    },
                    "writes": {
                        "count": 0,
                        "latency": 0
                    }
                },
                "replicated": {
                    "command": 0,
                    "delete": 0,
                    "getmore": 0,
                    "insert": 0,
                    "query": 0,
                    "update": 0
                }
            },
            "storage_engine": {
                "name": "wiredTiger"
            },
            "uptime": {
                "ms": 793190
            },
            "wired_tiger": {
                "cache": {
                    "dirty": {
                        "bytes": 0
                    },
                    "maximum": {
                        "bytes": 16113467392
                    },
                    "pages": {
                        "evicted": 0,
                        "read": 26,
                        "write": 22
                    },
                    "used": {
                        "bytes": 99789
                    }
                },
                "concurrent_transactions": {
                    "read": {
                        "available": 128,
                        "out": 0,
                        "total_tickets": 128
                    },
                    "write": {
                        "available": 128,
                        "out": 0,
                        "total_tickets": 128
                    }
                },
                "log": {
                    "flushes": 7918,
                    "max_file_size": {
                        "bytes": 104857600
                    },
                    "scans": 3,
                    "size": {
                        "bytes": 33554432
                    },
                    "syncs": 7,
                    "write": {
                        "bytes": 5120
                    },
                    "writes": 13
                }
            }
        }
    },
    "process": {
        "name": "mongod"
    },
    "service": {
        "address": "172.28.0.2:27017",
        "type": "mongodb",
        "version": "3.4.24"
    }
}
```