﻿---
title: MongoDB replstatus metricset
description: This is the replstatus metricset of the module mongodb. It requires the following privileges, which is covered by the clusterMonitor role: find/listCollections...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mongodb-replstatus
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MongoDB replstatus metricset
This is the `replstatus` metricset of the module mongodb.
It requires the following privileges, which is covered by the [`clusterMonitor` role](https://docs.mongodb.com/manual/reference/built-in-roles/#clusterMonitor):
- [`find`/`listCollections` action](https://docs.mongodb.com/manual/reference/privilege-actions/#find) on [the `local` database resource](https://docs.mongodb.com/manual/reference/local-database/)
- [`collStats` action](https://docs.mongodb.com/manual/reference/privilege-actions/#collStats) on [the `local.oplog.rs` collection resource](https://docs.mongodb.com/manual/reference/local-database/#local.oplog.rs)
- [`replSetGetStatus` action](https://docs.mongodb.com/manual/reference/privilege-actions/#replSetGetStatus) on [`cluster` resource](https://docs.mongodb.com/manual/reference/resource-document/#cluster-resource)


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mongodb) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "mongodb.replstatus",
        "duration": 115000,
        "module": "mongodb"
    },
    "metricset": {
        "name": "replstatus",
        "period": 10000
    },
    "mongodb": {
        "replstatus": {
            "headroom": {
                "max": null,
                "min": null
            },
            "lag": {
                "max": null,
                "min": null
            },
            "members": {
                "arbiter": {
                    "count": 0,
                    "hosts": null
                },
                "down": {
                    "count": 0,
                    "hosts": null
                },
                "primary": {
                    "host": "7ba9ef86c3b0:27017",
                    "optime": 1651925294
                },
                "recovering": {
                    "count": 0,
                    "hosts": null
                },
                "rollback": {
                    "count": 0,
                    "hosts": null
                },
                "secondary": {
                    "count": 0,
                    "hosts": null,
                    "optimes": null
                },
                "startup2": {
                    "count": 0,
                    "hosts": null
                },
                "unhealthy": {
                    "count": 0,
                    "hosts": null
                },
                "unknown": {
                    "count": 0,
                    "hosts": null
                }
            },
            "oplog": {
                "first": {
                    "timestamp": 1651925294
                },
                "last": {
                    "timestamp": 1651925294
                },
                "size": {
                    "allocated": 2379247206,
                    "used": 1323
                },
                "window": 0
            },
            "optimes": {
                "applied": 1651925294,
                "durable": 1651925294,
                "last_committed": 1651925294
            },
            "server_date": "2022-05-07T12:08:19.506Z",
            "set_name": "beats"
        }
    },
    "service": {
        "address": "172.28.0.3:27017",
        "type": "mongodb"
    }
}
```