﻿---
title: MongoDB metrics metricset
description: This is the metrics metricset of the MongoDB module. It requires the following privileges, which is covered by the clusterMonitor role: serverStatus action...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mongodb-metrics
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MongoDB metrics metricset
This is the `metrics` metricset of the MongoDB module.
It requires the following privileges, which is covered by the [`clusterMonitor` role](https://docs.mongodb.com/manual/reference/built-in-roles/#clusterMonitor):
- [`serverStatus` action](https://docs.mongodb.com/manual/reference/privilege-actions/#serverStatus) on [`cluster` resource](https://docs.mongodb.com/manual/reference/resource-document/#cluster-resource)

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mongodb) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "mongodb.metrics",
        "duration": 115000,
        "module": "mongodb"
    },
    "metricset": {
        "name": "metrics",
        "period": 10000
    },
    "mongodb": {
        "metrics": {
            "commands": {
                "aggregate": {
                    "failed": 0,
                    "total": 0
                },
                "build_info": {
                    "failed": 0,
                    "total": 0
                },
                "coll_stats": {
                    "failed": 0,
                    "total": 0
                },
                "connection_pool_stats": {
                    "failed": 0,
                    "total": 0
                },
                "count": {
                    "failed": 0,
                    "total": 0
                },
                "db_stats": {
                    "failed": 0,
                    "total": 0
                },
                "distinct": {
                    "failed": 0,
                    "total": 0
                },
                "find": {
                    "failed": 0,
                    "total": 1
                },
                "get_cmd_line_opts": {
                    "failed": 0,
                    "total": 0
                },
                "get_last_error": {
                    "failed": 0,
                    "total": 0
                },
                "get_log": {
                    "failed": 0,
                    "total": 0
                },
                "get_more": {
                    "failed": 0,
                    "total": 0
                },
                "get_parameter": {
                    "failed": 0,
                    "total": 0
                },
                "host_info": {
                    "failed": 0,
                    "total": 0
                },
                "insert": {
                    "failed": 0,
                    "total": 0
                },
                "is_master": {
                    "failed": 0,
                    "total": 6
                },
                "is_self": {
                    "failed": 0,
                    "total": 0
                },
                "last_collections": {
                    "failed": 0,
                    "total": 0
                },
                "last_commands": {
                    "failed": 0,
                    "total": 0
                },
                "list_databased": {
                    "failed": 0,
                    "total": 0
                },
                "list_indexes": {
                    "failed": 0,
                    "total": 2
                },
                "ping": {
                    "failed": 0,
                    "total": 0
                },
                "profile": {
                    "failed": 0,
                    "total": 0
                },
                "replset_get_rbid": {
                    "failed": 0,
                    "total": 0
                },
                "replset_get_status": {
                    "failed": 0,
                    "total": 0
                },
                "replset_heartbeat": {
                    "failed": 0,
                    "total": 0
                },
                "replset_update_position": {
                    "failed": 0,
                    "total": 0
                },
                "server_status": {
                    "failed": 0,
                    "total": 2
                },
                "update": {
                    "failed": 0,
                    "total": 0
                },
                "whatsmyuri": {
                    "failed": 0,
                    "total": 0
                }
            },
            "cursor": {
                "open": {
                    "no_timeout": 0,
                    "pinned": 0,
                    "total": 0
                },
                "timed_out": 0
            },
            "document": {
                "deleted": 0,
                "inserted": 0,
                "returned": 0,
                "updated": 0
            },
            "get_last_error": {
                "write_timeouts": 0,
                "write_wait": {
                    "count": 0,
                    "ms": 0
                }
            },
            "operation": {
                "scan_and_order": 0,
                "write_conflicts": 0
            },
            "query_executor": {
                "scanned_documents": {
                    "count": 0
                },
                "scanned_indexes": {
                    "count": 0
                }
            },
            "replication": {
                "apply": {
                    "attempts_to_become_secondary": 0,
                    "batches": {
                        "count": 0,
                        "time": {
                            "ms": 0
                        }
                    },
                    "ops": 0
                },
                "buffer": {
                    "count": 0,
                    "max_size": {
                        "bytes": 0
                    },
                    "size": {
                        "bytes": 0
                    }
                },
                "executor": {
                    "queues": {
                        "in_progress": {
                            "network": 0
                        },
                        "sleepers": 0
                    },
                    "shutting_down": false,
                    "unsignaled_events": 0
                },
                "initial_sync": {
                    "completed": 0,
                    "failed_attempts": 0,
                    "failures": 0
                },
                "network": {
                    "bytes": 0,
                    "getmores": {
                        "count": 0,
                        "time": {
                            "ms": 0
                        }
                    },
                    "ops": 0,
                    "reders_created": 0
                }
            },
            "ttl": {
                "deleted_documents": {
                    "count": 0
                },
                "passes": {
                    "count": 1
                }
            }
        }
    },
    "service": {
        "address": "172.28.0.3:27017",
        "type": "mongodb"
    }
}
```