﻿---
title: MongoDB dbstats metricset
description: This is the dbstats metricset of the MongoDB module. It requires the following privileges, which is covered by the clusterMonitor role: listDatabases...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mongodb-dbstats
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MongoDB dbstats metricset
This is the `dbstats` metricset of the MongoDB module.
It requires the following privileges, which is covered by the [`clusterMonitor` role](https://docs.mongodb.com/manual/reference/built-in-roles/#clusterMonitor):
- [`listDatabases` action](https://docs.mongodb.com/manual/reference/privilege-actions/#listDatabases) on [`cluster` resource](https://docs.mongodb.com/manual/reference/resource-document/#cluster-resource)
- for each of the databases, also need [`dbStats` action](https://docs.mongodb.com/manual/reference/privilege-actions/#dbStats) on the [`database` resource](https://docs.mongodb.com/manual/reference/resource-document/#database-and-or-collection-resource)

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mongodb) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "mongodb.dbstats",
        "duration": 115000,
        "module": "mongodb"
    },
    "metricset": {
        "name": "dbstats",
        "period": 10000
    },
    "mongodb": {
        "dbstats": {
            "avg_obj_size": {
                "bytes": 59
            },
            "collections": 1,
            "data_size": {
                "bytes": 59
            },
            "db": "admin",
            "file_size": {},
            "index_size": {
                "bytes": 20480
            },
            "indexes": 1,
            "ns_size_mb": {},
            "objects": 1,
            "storage_size": {
                "bytes": 20480
            }
        }
    },
    "service": {
        "address": "172.28.0.2:27017",
        "type": "mongodb"
    }
}
```