﻿---
title: MongoDB collstats metricset
description: This is the collstats metricset of the module mongodb. It is using the top administrative command to return usage statistics for each collection. It provides...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-mongodb-collstats
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# MongoDB collstats metricset
This is the `collstats` metricset of the module mongodb.
It is using the `top` administrative command to return usage statistics for each collection. It provides the amount of time, in microseconds, used and a count of operations for the following types:
- total
- readLock
- writeLock
- queries
- getmore
- insert
- update
- remove
- commands

It requires the following privileges, which is covered by the [`clusterMonitor` role](https://docs.mongodb.com/manual/reference/built-in-roles/#clusterMonitor):
- [`top` action](https://docs.mongodb.com/manual/reference/privilege-actions/#top) on [`cluster` resource](https://docs.mongodb.com/manual/reference/resource-document/#cluster-resource)

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-mongodb) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "mongodb.collstats",
        "duration": 115000,
        "module": "mongodb"
    },
    "metricset": {
        "name": "collstats",
        "period": 10000
    },
    "mongodb": {
        "collstats": {
            "collection": "oplog.rs",
            "commands": {
                "count": 0,
                "time": {
                    "us": 0
                }
            },
            "db": "local",
            "getmore": {
                "count": 0,
                "time": {
                    "us": 0
                }
            },
            "insert": {
                "count": 0,
                "time": {
                    "us": 0
                }
            },
            "lock": {
                "read": {
                    "count": 1,
                    "time": {
                        "us": 7
                    }
                },
                "write": {
                    "count": 1,
                    "time": {
                        "us": 6600
                    }
                }
            },
            "name": "local.oplog.rs",
            "queries": {
                "count": 0,
                "time": {
                    "us": 0
                }
            },
            "remove": {
                "count": 0,
                "time": {
                    "us": 0
                }
            },
            "total": {
                "count": 2,
                "time": {
                    "us": 6607
                }
            },
            "update": {
                "count": 0,
                "time": {
                    "us": 0
                }
            },
            "stats": {
                "totalSize": 8192,
                "max": 5000,
                "nindexes": 1,
                "size": 36,
                "count": 1,
                "avgObjSize": 36,
                "storageSize": 4096,
                "totalIndexSize": 4096
            }
        }
    },
    "service": {
        "address": "172.28.0.5:27017",
        "type": "mongodb"
    }
}
```