﻿---
title: Linux pressure metricset
description: The Pressure module reports Pressure Stall Information (PSI) collected for the cpu, memory, and io files/resources found in /proc/pressure. PSI metrics...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-pressure
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux pressure metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The Pressure module reports [Pressure Stall Information (PSI)](https://www.kernel.org/doc/Documentation/accounting/psi.txt) collected for the `cpu`, `memory`, and `io` files/resources found in `/proc/pressure`. PSI metrics are included in Linux kernel versions from 4.20. Some distributions might have PSI support, but have disabled the feature via the `CONFIG_PSI_DEFAULT_DISABLED` setting, to enable PSI metrics pass `psi=1` on the kernel command line during boot.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "linux.pressure",
        "duration": 115000,
        "module": "linux"
    },
    "linux": {
        "pressure": {
            "cpu": {
                "some": {
                    "10": 1.63,
                    "300": 0.06,
                    "60": 0.29,
                    "total": 155911207
                }
            }
        }
    },
    "metricset": {
        "name": "pressure",
        "period": 10000
    },
    "service": {
        "type": "linux"
    }
}
```