﻿---
title: Linux pageinfo metricset
description: The pageinfo metricset reports on paging statistics as found in /proc/pagetypeinfo Reported metrics are broken down by page type: DMA, DMA32, Normal,...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-pageinfo
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux pageinfo metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The pageinfo metricset reports on paging statistics as found in `/proc/pagetypeinfo`
Reported metrics are broken down by page type: DMA, DMA32, Normal, and Highmem. These types are further broken down by order, which represents zones of 2^ORDER*PAGE_SIZE. These metrics are divided into two reporting types: `buddyinfo`, which is summarized by page type, as in `/proc/buddyinfo`. `nodes` reports info broken down by memory migration type.
This information can be used to determine memory fragmentation. The kernel [buddy algorithim](https://www.kernel.org/doc/gorman/html/understand/understand009.html) will always search for the smallest page order to allocate, and if none is available, a larger page order will be split into two "buddies." When memory is freed, the kernel will attempt to merge the "buddies." If the only available pages are at lower orders, this indicates fragmentation, as buddy pages cannot be merged.
Note that page counts from `/proc/pagetypeinfo` will only display values up to 100,000.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "linux.pageinfo",
        "duration": 115000,
        "module": "linux"
    },
    "linux": {
        "pageinfo": {
            "buddy_info": {
                "DMA": {
                    "0": 1,
                    "1": 0,
                    "10": 3,
                    "2": 1,
                    "3": 0,
                    "4": 2,
                    "5": 1,
                    "6": 1,
                    "7": 0,
                    "8": 1,
                    "9": 1
                },
                "DMA32": {
                    "0": 3,
                    "1": 4,
                    "10": 745,
                    "2": 1,
                    "3": 2,
                    "4": 2,
                    "5": 2,
                    "6": 2,
                    "7": 2,
                    "8": 2,
                    "9": 3
                },
                "Normal": {
                    "0": 3409,
                    "1": 4916,
                    "10": 292,
                    "2": 4010,
                    "3": 4853,
                    "4": 3613,
                    "5": 2472,
                    "6": 793,
                    "7": 552,
                    "8": 189,
                    "9": 148
                }
            },
            "nodes": {
                "0": {
                    "DMA": {
                        "CMA": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "HighAtomic": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Isolate": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Movable": {
                            "0": 0,
                            "1": 0,
                            "10": 3,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 1
                        },
                        "Reclaimable": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Unmovable": {
                            "0": 1,
                            "1": 0,
                            "10": 0,
                            "2": 1,
                            "3": 0,
                            "4": 2,
                            "5": 1,
                            "6": 1,
                            "7": 0,
                            "8": 1,
                            "9": 0
                        }
                    },
                    "DMA32": {
                        "CMA": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "HighAtomic": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Isolate": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Movable": {
                            "0": 3,
                            "1": 3,
                            "10": 745,
                            "2": 1,
                            "3": 2,
                            "4": 2,
                            "5": 2,
                            "6": 2,
                            "7": 1,
                            "8": 1,
                            "9": 2
                        },
                        "Reclaimable": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Unmovable": {
                            "0": 0,
                            "1": 1,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 1,
                            "8": 1,
                            "9": 1
                        }
                    },
                    "Normal": {
                        "CMA": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "HighAtomic": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Isolate": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 0,
                            "3": 0,
                            "4": 0,
                            "5": 0,
                            "6": 0,
                            "7": 0,
                            "8": 0,
                            "9": 0
                        },
                        "Movable": {
                            "0": 3137,
                            "1": 4732,
                            "10": 291,
                            "2": 3687,
                            "3": 2993,
                            "4": 2337,
                            "5": 1504,
                            "6": 355,
                            "7": 404,
                            "8": 155,
                            "9": 141
                        },
                        "Reclaimable": {
                            "0": 0,
                            "1": 0,
                            "10": 0,
                            "2": 1,
                            "3": 3,
                            "4": 227,
                            "5": 534,
                            "6": 305,
                            "7": 124,
                            "8": 31,
                            "9": 5
                        },
                        "Unmovable": {
                            "0": 272,
                            "1": 184,
                            "10": 1,
                            "2": 322,
                            "3": 1857,
                            "4": 1049,
                            "5": 434,
                            "6": 133,
                            "7": 24,
                            "8": 3,
                            "9": 2
                        }
                    },
                    "order_summary": {
                        "0": 3413,
                        "1": 4920,
                        "10": 1040,
                        "2": 4012,
                        "3": 4855,
                        "4": 3617,
                        "5": 2475,
                        "6": 796,
                        "7": 554,
                        "8": 192,
                        "9": 152
                    }
                }
            }
        }
    },
    "metricset": {
        "name": "pageinfo",
        "period": 10000
    },
    "service": {
        "type": "linux"
    }
}
```