﻿---
title: Linux memory metricset
description: The memory metricset extends system/memory and adds linux-specific memory metrics, including Huge Pages and overall paging statistics. This is a default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-memory
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux memory metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The memory metricset extends system/memory and adds linux-specific memory metrics, including Huge Pages and overall paging statistics.
<note>
  as of now, this data is part of system/memory on Metricbeat, but can only be found in the Linux integration in Fleet. In the future, this data will be removed from system/memory.
</note>

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "linux.memory",
        "duration": 115000,
        "module": "linux"
    },
    "linux": {
        "memory": {
            "hugepages": {
                "default_size": 2097152,
                "free": 0,
                "reserved": 0,
                "surplus": 0,
                "swap": {
                    "out": {
                        "fallback": 0,
                        "pages": 0
                    }
                },
                "total": 0,
                "used": {
                    "bytes": 0,
                    "pct": 0
                }
            },
            "page_stats": {
                "direct_efficiency": {
                    "pct": 0.3419
                },
                "kswapd_efficiency": {
                    "pct": 0.8922
                },
                "pgfree": {
                    "pages": 16328309361
                },
                "pgscan_direct": {
                    "pages": 21037589
                },
                "pgscan_kswapd": {
                    "pages": 49831
                },
                "pgsteal_direct": {
                    "pages": 7193725
                },
                "pgsteal_kswapd": {
                    "pages": 44459
                }
            },
            "swap": {
                "free": 8586252288,
                "in": {
                    "pages": 72435
                },
                "out": {
                    "pages": 2032475
                },
                "readahead": {
                    "cached": 5,
                    "pages": 29
                },
                "total": 8589930496,
                "used": {
                    "bytes": 3678208,
                    "pct": 0.0004
                }
            },
            "vmstat": {
                "allocstall_dma": 0,
                "allocstall_dma32": 0,
                "allocstall_movable": 60572,
                "allocstall_normal": 1125,
                "balloon_deflate": 0,
                "balloon_inflate": 0,
                "balloon_migrate": 0,
                "cma_alloc_fail": 0,
                "cma_alloc_success": 0,
                "compact_daemon_free_scanned": 0,
                "compact_daemon_migrate_scanned": 0,
                "compact_daemon_wake": 2,
                "compact_fail": 0,
                "compact_free_scanned": 406096,
                "compact_isolated": 15241,
                "compact_migrate_scanned": 51056,
                "compact_stall": 0,
                "compact_success": 0,
                "direct_map_level2_splits": 864,
                "direct_map_level3_splits": 52,
                "drop_pagecache": 0,
                "drop_slab": 0,
                "htlb_buddy_alloc_fail": 0,
                "htlb_buddy_alloc_success": 0,
                "kswapd_high_wmark_hit_quickly": 0,
                "kswapd_inodesteal": 2,
                "kswapd_low_wmark_hit_quickly": 1,
                "nr_active_anon": 5553,
                "nr_active_file": 1478109,
                "nr_anon_pages": 1024369,
                "nr_anon_transparent_hugepages": 140,
                "nr_bounce": 0,
                "nr_dirtied": 87806596,
                "nr_dirty": 60,
                "nr_dirty_background_threshold": 1339484,
                "nr_dirty_threshold": 2682244,
                "nr_file_hugepages": 0,
                "nr_file_pages": 5302193,
                "nr_file_pmdmapped": 0,
                "nr_foll_pin_acquired": 2,
                "nr_foll_pin_released": 2,
                "nr_free_cma": 0,
                "nr_free_pages": 8219610,
                "nr_inactive_anon": 1046105,
                "nr_inactive_file": 3825289,
                "nr_isolated_anon": 0,
                "nr_isolated_file": 0,
                "nr_kernel_misc_reclaimable": 0,
                "nr_kernel_stack": 14144,
                "nr_mapped": 191441,
                "nr_mlock": 0,
                "nr_page_table_pages": 6756,
                "nr_shmem": 9446,
                "nr_shmem_hugepages": 0,
                "nr_shmem_pmdmapped": 0,
                "nr_slab_reclaimable": 362837,
                "nr_slab_unreclaimable": 167630,
                "nr_swapcached": 2,
                "nr_throttled_written": 0,
                "nr_unevictable": 768,
                "nr_unstable": 0,
                "nr_vmscan_immediate_reclaim": 10,
                "nr_vmscan_write": 2032594,
                "nr_writeback": 0,
                "nr_writeback_temp": 0,
                "nr_written": 77862049,
                "nr_zone_active_anon": 5553,
                "nr_zone_active_file": 1478109,
                "nr_zone_inactive_anon": 1046105,
                "nr_zone_inactive_file": 3825289,
                "nr_zone_unevictable": 768,
                "nr_zone_write_pending": 60,
                "nr_zspages": 477,
                "numa_foreign": 0,
                "numa_hint_faults": 0,
                "numa_hint_faults_local": 0,
                "numa_hit": 16320172649,
                "numa_huge_pte_updates": 0,
                "numa_interleave": 2819,
                "numa_local": 16319863485,
                "numa_miss": 0,
                "numa_other": 0,
                "numa_pages_migrated": 0,
                "numa_pte_updates": 0,
                "oom_kill": 0,
                "pageoutrun": 2,
                "pgactivate": 49439150,
                "pgalloc_dma": 1024,
                "pgalloc_dma32": 819165,
                "pgalloc_movable": 0,
                "pgalloc_normal": 16318820409,
                "pgdeactivate": 2560804,
                "pgdemote_direct": 0,
                "pgdemote_kswapd": 0,
                "pgfault": 19447993645,
                "pgfree": 16328309361,
                "pginodesteal": 677,
                "pglazyfree": 40011,
                "pglazyfreed": 4375,
                "pgmajfault": 112209,
                "pgmigrate_fail": 778,
                "pgmigrate_success": 7169,
                "pgpgin": 28240034,
                "pgpgout": 472429900,
                "pgrefill": 2602042,
                "pgreuse": 742840224,
                "pgrotated": 316,
                "pgscan_anon": 15494945,
                "pgscan_direct": 21037589,
                "pgscan_direct_throttle": 0,
                "pgscan_file": 5592475,
                "pgscan_kswapd": 49831,
                "pgskip_dma": 0,
                "pgskip_dma32": 0,
                "pgskip_movable": 0,
                "pgskip_normal": 0,
                "pgsteal_anon": 2032475,
                "pgsteal_direct": 7193725,
                "pgsteal_file": 5205709,
                "pgsteal_kswapd": 44459,
                "pswpin": 72435,
                "pswpout": 2032475,
                "slabs_scanned": 1097218,
                "swap_ra": 29,
                "swap_ra_hit": 5,
                "thp_collapse_alloc": 1212,
                "thp_collapse_alloc_failed": 0,
                "thp_deferred_split_page": 861,
                "thp_fault_alloc": 10248,
                "thp_fault_fallback": 0,
                "thp_fault_fallback_charge": 0,
                "thp_file_alloc": 0,
                "thp_file_fallback": 0,
                "thp_file_fallback_charge": 0,
                "thp_file_mapped": 0,
                "thp_migration_fail": 0,
                "thp_migration_split": 0,
                "thp_migration_success": 0,
                "thp_split_page": 0,
                "thp_split_page_failed": 0,
                "thp_split_pmd": 3813,
                "thp_split_pud": 0,
                "thp_swpout": 0,
                "thp_swpout_fallback": 0,
                "thp_zero_page_alloc": 2,
                "thp_zero_page_alloc_failed": 0,
                "unevictable_pgs_cleared": 0,
                "unevictable_pgs_culled": 56303,
                "unevictable_pgs_mlocked": 36952,
                "unevictable_pgs_munlocked": 36952,
                "unevictable_pgs_rescued": 36952,
                "unevictable_pgs_scanned": 0,
                "unevictable_pgs_stranded": 0,
                "workingset_activate_anon": 33561,
                "workingset_activate_file": 56974,
                "workingset_nodereclaim": 130600,
                "workingset_nodes": 9668,
                "workingset_refault_anon": 72435,
                "workingset_refault_file": 448332,
                "workingset_restore_anon": 0,
                "workingset_restore_file": 40457,
                "zone_reclaim_failed": 0
            }
        }
    },
    "metricset": {
        "name": "memory",
        "period": 10000
    },
    "service": {
        "type": "linux"
    }
}
```