﻿---
title: Linux ksm metricset
description: The KSM module reports data from Kernel Samepage Merging. In order to take advantage of KSM, applications must use the madvise system call to mark memory...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-ksm
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux ksm metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The KSM module reports data from [Kernel Samepage Merging](https://www.kernel.org/doc/html/latest/admin-guide/mm/ksm.html). In order to take advantage of KSM, applications must use the `madvise` system call to mark memory regions for merging. KSM is not enabled on all distros, and KSM status is set with the `CONFIG_KSM` kernel flag.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "linux.ksm",
        "duration": 115000,
        "module": "linux"
    },
    "linux": {
        "ksm": {
            "stats": {
                "pages_shared": 100,
                "pages_sharing": 10,
                "pages_unshared": 0,
                "pages_volatile": 0,
                "full_scans": 2000,
                "stable_node_chains": 0,
                "stable_node_dups": 0
            }
        }
    },
    "metricset": {
        "name": "ksm",
        "period": 10000
    },
    "service": {
        "type": "linux"
    }
}
```