﻿---
title: Linux iostat metricset
description: The iostat module reports per-disk IO statistics that emulate iostat -x on linux. For a description of each field in the metricset, see the exported fields...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-iostat
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux iostat metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The iostat module reports per-disk IO statistics that emulate `iostat -x` on linux.
<note>
  as of now, this data is part of system/diskio on Metricbeat, but can only be found in the Linux integration in Fleet. In the future, this data will be removed from system/memory.
</note>


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "linux.iostat",
        "duration": 115000,
        "module": "linux"
    },
    "linux": {
        "iostat": {
            "await": 0,
            "busy": 0.1503,
            "name": "sda",
            "queue": {
                "avg_size": 0.0005
            },
            "read": {
                "await": 0,
                "per_sec": {
                    "bytes": 0
                },
                "request": {
                    "merges_per_sec": 0,
                    "per_sec": 0
                }
            },
            "request": {
                "avg_size": 2867.2
            },
            "service_time": 0.3,
            "write": {
                "await": 0,
                "per_sec": {
                    "bytes": 14365.929
                },
                "request": {
                    "merges_per_sec": 0,
                    "per_sec": 5.0104
                }
            }
        }
    },
    "metricset": {
        "name": "iostat",
        "period": 10000
    },
    "service": {
        "type": "linux"
    }
}
```