﻿---
title: Linux conntrack metricset
description: The conntrack module reports on performance counters for the linux connection tracking component of netfilter. Conntrack uses a hash table to track the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-linux-conntrack
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Linux conntrack metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

The conntrack module reports on performance counters for the linux connection tracking component of netfilter. Conntrack uses a [hash table](http://people.netfilter.org/pablo/docs/login.pdf) to track the state of network connections.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-linux) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "linux.conntrack",
        "duration": 115000,
        "module": "linux"
    },
    "linux": {
        "conntrack": {
            "summary": {
                "drop": 0,
                "early_drop": 0,
                "entries": 16,
                "found": 0,
                "ignore": 3271028,
                "insert_failed": 0,
                "invalid": 122,
                "search_restart": 3
            }
        }
    },
    "metricset": {
        "name": "conntrack",
        "period": 10000
    },
    "service": {
        "type": "linux"
    }
}
```