﻿---
title: Kubernetes volume metricset
description: This is the volume metricset of the Kubernetes module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kubernetes-volume
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes volume metricset
This is the `volume` metricset of the Kubernetes module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-04-06T15:29:27.150Z",
    "beat": {
        "hostname": "beathost",
        "name": "beathost",
        "version": "6.0.0-alpha1"
    },
    "kubernetes": {
        "namespace": "ns",
        "node": {
          "name": "localhost",
        },
        "pod": {
            "name": "nginx-3137573019-pcfzh",
        },
        "volume": {
            "fs": {
                "available": {
                    "bytes": 92849512448
                },
                "capacity": {
                    "bytes": 92849524736
                },
                "inodes": {
                    "count": 22668341,
                    "free": 22668332,
                    "used": 9
                },
                "used": {
                    "bytes": 12288
                }
            },
            "name": "default-token-4fkmg"
        }
    },
    "metricset": {
        "host": "localhost:10255",
        "module": "kubernetes",
        "name": "volume",
        "rtt": 648606
    },
    "type": "metricsets"
}
```