﻿---
title: Kubernetes system metricset
description: This is the system metricset of the Kubernetes module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kubernetes-system
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes system metricset
This is the `system` metricset of the Kubernetes module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-04-06T15:29:27.150Z",
    "beat": {
        "hostname": "beathost",
        "name": "beathost",
        "version": "6.0.0-alpha1"
    },
    "kubernetes": {
        "node": {
            "name": "localhost"
        },
        "system": {
            "container": "kubernetes",
            "cpu": {
                "usage": {
                    "core": {
                        "ns": 1424273250468228
                    },
                    "nanocores": 382404825
                }
            },
            "memory": {
                "majorpagefaults": 49,
                "pagefaults": 22921778663,
                "rss": {
                    "bytes": 159412224
                },
                "usage": {
                    "bytes": 223035392
                },
                "workingset": {
                    "bytes": 169037824
                }
            },
            "start_time": "2017-02-08T10:35:02Z"
        }
    },
    "metricset": {
        "host": "localhost:10255",
        "module": "kubernetes",
        "name": "system",
        "rtt": 640649
    },
    "type": "metricsets"
}
```