﻿---
title: Kubernetes state_cronjob metricset
description: This is the state_cronjob metricset of the Kubernetes module. This metricset adds metadata by default only for versions of k8s >= v1.21. For older versions...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kubernetes-state_cronjob
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes state_cronjob metricset
This is the `state_cronjob` metricset of the Kubernetes module.
This metricset adds metadata by default only for versions of k8s >= v1.21. For older versions the APIs are not compatible and one need to configure the metricset with `add_metadata: false` and remove the proper `apiGroup` in the `ClusterRole`:
```yaml
- apiGroups: [ "batch" ]
  resources:
  - cronjobs
```


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "event": {
        "dataset": "kubernetes.cronjob",
        "duration": 115000,
        "module": "kubernetes"
    },
    "kubernetes": {
        "cronjob": {
            "active": {
                "count": 0
            },
            "created": {
                "sec": 1744115807
            },
            "is_suspended": false,
            "last_schedule": {
                "sec": 1744115820
            },
            "name": "hello",
            "next_schedule": {
                "sec": 1744115880
            }
        },
        "namespace": "default"
    },
    "metricset": {
        "name": "state_cronjob",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "kubernetes"
    }
}
```