﻿---
title: Kubernetes pod metricset
description: This is the pod metricset of the Kubernetes module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by default...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kubernetes-pod
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes pod metricset
This is the `pod` metricset of the Kubernetes module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-04-06T15:29:27.150Z",
    "beat": {
        "hostname": "beathost",
        "name": "beathost",
        "version": "6.0.0-alpha1"
    },
    "kubernetes": {
        "namespace": "ns",
        "node": {
          "name": "localhost",
        },
        "pod": {
            "name": "nginx-3137573019-pcfzh",
            "uid": "b89a812e-18cd-11e9-b333-080027190d51",
            "network": {
                "rx": {
                    "bytes": 18999261,
                    "errors": 0
                },
                "tx": {
                    "bytes": 28580621,
                    "errors": 0
                }
            },
            "start_time": "2017-04-06T12:09:05Z"
        }
    },
    "metricset": {
        "host": "localhost:10255",
        "module": "kubernetes",
        "name": "pod",
        "rtt": 636230
    },
    "type": "metricsets"
}
```