﻿---
title: Kubernetes container metricset
description: This is the container metricset of the Kubernetes module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kubernetes-container
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes container metricset
This is the `container` metricset of the Kubernetes module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-04-06T15:29:27.150Z",
    "beat": {
        "hostname": "beathost",
        "name": "beathost",
        "version": "6.0.0-alpha1"
    },
    "kubernetes": {
        "container": {
            "cpu": {
                "usage": {
                    "core": {
                        "ns": 3305756719
                    },
                    "nanocores": 5992
                }
            },
            "logs": {
                "available": {
                    "bytes": 1188063105024
                },
                "capacity": {
                    "bytes": 1197211648000
                },
                "inodes": {
                    "count": 584581120,
                    "free": 584447029,
                    "used": 134091
                },
                "used": {
                    "bytes": 0
                }
            },
            "memory": {
                "available": {
                    "bytes": 0
                },
                "majorpagefaults": 47,
                "pagefaults": 2298,
                "rss": {
                    "bytes": 1441792
                },
                "usage": {
                    "bytes": 7643136
                },
                "workingset": {
                    "bytes": 1466368
                }
            },
            "name": "nginx",
            "rootfs": {
                "available": {
                    "bytes": 64694517760
                },
                "capacity": {
                    "bytes": 142782496768
                },
                "inodes": {
                    "used": 0
                },
                "used": {
                    "bytes": 16777216
                }
            },
            "start_time": "2017-04-03T10:01:56Z"
        },
        "namespace": "ns",
        "node": {
          "name": "localhost"
        },
        "pod": {
            "name": "nginx-3137573019-pcfzh",
        }
    },
    "metricset": {
        "host": "localhost:10255",
        "module": "kubernetes",
        "name": "container",
        "rtt": 650739
    },
    "type": "metricsets"
}
```