﻿---
title: Kubernetes apiserver metricset
description: This is the apiserver metricset of the Kubernetes module, in charge of retrieving metrics from the Kubernetes API (available at /metrics). This metricset...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kubernetes-apiserver
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kubernetes apiserver metricset
This is the `apiserver` metricset of the Kubernetes module, in charge of retrieving metrics from the Kubernetes API (available at `/metrics`).
This metricset needs access to the `apiserver` component of Kubernetes, accessible typically by any POD via the `kubernetes.default` service or via environment variables (`KUBERNETES_SERVICE_HOST` and `KUBERNETES_SERVICE_PORT`).
When the API uses https, the pod will need to authenticate using its default token and trust the server using the appropiate CA file.
Configuration example using https and token based authentication:
```yaml
- module: kubernetes
  enabled: true
  metricsets:
    - apiserver
  hosts: ["https://${KUBERNETES_SERVICE_HOST}:${KUBERNETES_SERVICE_PORT}"]
  #hosts: ["https://kubernetes.default"]
  bearer_token_file: /var/run/secrets/kubernetes.io/serviceaccount/token
  ssl.certificate_authorities:
    - /var/run/secrets/kubernetes.io/serviceaccount/ca.crt
  period: 30s
```

In order to access the `/metrics` path of the API service, some Kubernetes environments might require the following permission to be added to a ClusterRole.
```yaml
rules:
- nonResourceURLs:
  - /metrics
  verbs:
  - get
```

The previous configuration and RBAC requirement is available in the complete example manifest proposed in [Running Metricbeat on Kubernetes](https://www.elastic.co/docs/reference/beats/metricbeat/running-on-kubernetes) document.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kubernetes) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "event": {
        "dataset": "kubernetes.apiserver",
        "duration": 115000,
        "module": "kubernetes"
    },
    "kubernetes": {
        "apiserver": {
            "major": {
                "version": "1"
            },
            "minor": {
                "version": "21"
            },
            "request": {
                "code": "0",
                "component": "apiserver",
                "count": 14,
                "resource": "endpoints",
                "scope": "cluster",
                "verb": "WATCH",
                "version": "v1"
            }
        }
    },
    "metricset": {
        "name": "apiserver",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "type": "kubernetes"
    }
}
```