﻿---
title: Kibana status metricset
description: This is the status metricset of the Kibana module. This status endpoint is available in 6.0 by default and can be enabled in Kibana >= 5.4 with the config...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-status
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kibana status metricset
This is the `status` metricset of the Kibana module. This status endpoint is available in 6.0 by default and can be enabled in Kibana >= 5.4 with the config option `status.v6ApiFormat: true`.
The intention of the Kibana module is to have a minimal data set that works across Kibana versions.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kibana) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-03-01T08:05:34.853Z",
    "event": {
        "dataset": "kibana.status",
        "duration": 115000,
        "module": "kibana"
    },
    "kibana": {
        "status": {
            "metrics": {
                "concurrent_connections": 12,
                "requests": {
                    "disconnects": 3,
                    "total": 241
                }
            },
            "name": "ruflin",
            "status": {
                "overall": {
                    "state": "green"
                }
            }
        }
    },
    "metricset": {
        "name": "status",
        "period": 10000
    },
    "service": {
        "address": "127.0.0.1:55555",
        "id": "5b2de169-2785-441b-ae8c-186a1936b17d",
        "name": "kibana",
        "type": "kibana",
        "version": "6.0.0-alpha1"
    }
}
```