﻿---
title: Kibana stats metricset
description: This is the stats metricset of the Kibana module. This stats endpoint is available in 6.4 by default. The intention of the Kibana module is to have a...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kibana-stats
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kibana stats metricset
This is the `stats` metricset of the Kibana module. This stats endpoint is available in 6.4 by default.
The intention of the Kibana module is to have a minimal data set that works across Kibana versions.

## Module-specific configuration notes

If the Kibana instance is using a basepath in its URL, you must set the `basepath` setting for this module with the same value.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kibana) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "kibana.stats",
        "duration": 115000,
        "module": "kibana"
    },
    "kibana": {
        "elasticsearch": {
            "cluster": {
                "id": "WocBBA0QRma0sGpdQ7vLfQ"
            }
        },
        "stats": {
            "concurrent_connections": 4,
            "host": {
                "name": "0.0.0.0"
            },
            "index": ".kibana",
            "name": "b04775fa6831",
            "os": {
                "distro": "CentOS",
                "distroRelease": "CentOS-8.4.2105\n",
                "load": {
                    "15m": 1.12,
                    "1m": 0.97,
                    "5m": 1.01
                },
                "memory": {
                    "free_in_bytes": 323694592,
                    "total_in_bytes": 33295835136,
                    "used_in_bytes": 32972140544
                },
                "platform": "linux",
                "platformRelease": "linux-5.14.13-200.fc34.x86_64"
            },
            "process": {
                "event_loop_delay": {
                    "ms": 0.14306800067424774
                },
                "event_loop_utilization": {
                    "active": 629.1224170000005,
                    "idle": 359.23554199999995,
                    "utilization": 0.6365329598160299
                },
                "memory": {
                    "heap": {
                        "size_limit": {
                            "bytes": 4345298944
                        },
                        "total": {
                            "bytes": 264982528
                        },
                        "used": {
                            "bytes": 226086648
                        }
                    },
                    "resident_set_size": {
                        "bytes": 346976256
                    }
                },
                "uptime": {
                    "ms": 79081
                }
            },
            "request": {
                "disconnects": 0,
                "total": 7
            },
            "response_time": {
                "avg": {
                    "ms": 74
                },
                "max": {
                    "ms": 389
                }
            },
            "snapshot": false,
            "status": "green",
            "transport_address": "0.0.0.0:5601"
        }
    },
    "metricset": {
        "name": "stats",
        "period": 10000
    },
    "process": {
        "pid": 1222
    },
    "service": {
        "address": "172.19.0.3:5601",
        "id": "f87393a7-e8ae-48fd-af1e-91f229fd93fd",
        "type": "kibana",
        "version": "7.14.0"
    }
}
```