﻿---
title: Kafka partition metricset
description: This is the partition metricset of the Kafka module. As the partition metricset fetches the data from the complete Kafka cluster, only one connection...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kafka-partition
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kafka partition metricset
This is the partition metricset of the Kafka module.

## Configuration

As the partition metricset fetches the data from the complete Kafka cluster, only one connection host has to be defined. Currently if multiple hosts are defined, the data is fetched multiple times. Support for multiple initial connections host is planned to be added in future releases.

## Metricset

The current implementation of the partition metricset fetches the data for all leader partitions. Data for the replicas is not available yet.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kafka) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "kafka.partition",
        "duration": 115000,
        "module": "kafka"
    },
    "kafka": {
        "broker": {
            "address": "172.21.0.2:9092",
            "id": 0
        },
        "partition": {
            "id": 0,
            "offset": {
                "newest": 1,
                "oldest": 0
            },
            "partition": {
                "insync_replica": true,
                "is_leader": true,
                "leader": 0,
                "replica": 0
            },
            "topic_broker_id": "0-metricbeat-generate-data-0",
            "topic_id": "0-metricbeat-generate-data"
        },
        "topic": {
            "name": "metricbeat-generate-data"
        }
    },
    "metricset": {
        "name": "partition",
        "period": 10000
    },
    "service": {
        "address": "172.21.0.2:9092",
        "type": "kafka"
    }
}
```