﻿---
title: Kafka consumergroup metricset
description: This is the consumergroup metricset of the Kafka module. This is a default metricset. If the host module is unconfigured, this metricset is enabled by...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kafka-consumergroup
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Kafka consumergroup metricset
This is the `consumergroup` metricset of the Kafka module.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kafka) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "event": {
        "dataset": "kafka.consumergroup",
        "duration": 115000,
        "module": "kafka"
    },
    "kafka": {
        "broker": {
            "address": "172.21.0.2:9092",
            "id": 0
        },
        "consumergroup": {
            "client": {
                "host": "127.0.0.1",
                "id": "consumer-1",
                "member_id": "consumer-1-8653cb3a-afed-4b1b-87d0-2a208319b41e"
            },
            "consumer_lag": 77,
            "error": {
                "code": 0
            },
            "id": "console-consumer-40539",
            "meta": "",
            "offset": -1
        },
        "partition": {
            "id": 0,
            "topic_id": "0-test"
        },
        "topic": {
            "name": "test"
        }
    },
    "metricset": {
        "name": "consumergroup",
        "period": 10000
    },
    "service": {
        "address": "172.21.0.2:9092",
        "type": "kafka"
    }
}
```