﻿---
title: Kafka consumer metricset
description: This metricset periodically fetches JMX metrics from Kafka Consumers implemented in java and expose JMX metrics through jolokia agent. The module has...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kafka-consumer
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Kafka consumer metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This metricset periodically fetches JMX metrics from Kafka Consumers implemented in java and expose JMX metrics through jolokia agent.

## Compatibility

The module has been tested with Kafka 2.1.1, 2.2.2, 3.6.0 and 4.0.0. Other versions are expected to work.

## Usage

The Consumer metricset requires [Jolokia](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-jolokia)to fetch JMX metrics. Refer to the link for more information about Jolokia.
Note that the Jolokia agent is required to be deployed along with the JVM application. This can be achieved by using the `KAFKA_OPTS` environment variable when starting the Kafka consumer application:
```shell
export KAFKA_OPTS=-javaagent:/opt/jolokia-jvm-1.5.0-agent.jar=port=8774,host=localhost
./bin/kafka-console-consumer.sh --topic=test --bootstrap-server=localhost:9091
```

Then it will be possible to collect the JMX metrics from `localhost:8774`.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kafka) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-10-31T13:22:06.700Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "kafka": {
        "consumer": {
            "bytes_consumed": 2.9521300228e+10,
            "fetch_rate": 0,
            "records_consumed": 1.23075656e+08,
            "mbean": "kafka.consumer:client-id=consumer-1,type=consumer-fetch-manager-metrics"
        }
    },
    "event": {
        "dataset": "kafka.consumer",
        "module": "kafka",
        "duration": 7042831
    },
    "ecs": {
        "version": "1.2.0"
    },
    "host": {
        "name": "pr.local",
        "hostname": "pr.local",
        "architecture": "x86_64",
        "os": {
            "kernel": "18.7.0",
            "build": "18G95",
            "platform": "darwin",
            "version": "10.14.6",
            "family": "darwin",
            "name": "Mac OS X"
        },
        "id": "883134FF-0EC4-5E1B-9F9E-FD06FB681D84"
    },
    "agent": {
        "hostname": "pr.local",
        "id": "79dd1677-1bea-4efd-9131-e8ca464eddf0",
        "version": "8.0.0",
        "type": "metricbeat",
        "ephemeral_id": "e40f5843-d3aa-4bdc-a100-64022b70851b"
    },
    "metricset": {
        "name": "consumer",
        "period": 10000
    },
    "service": {
        "address": "localhost:8774",
        "type": "kafka"
    }
}
```