﻿---
title: Kafka broker metricset
description: This metricset periodically fetches JMX metrics from Kafka Broker JMX. The module has been tested with Kafka 2.1.1, 2.2.2, 3.6.0 and 4.0.0. Other versions...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-kafka-broker
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# Kafka broker metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This metricset periodically fetches JMX metrics from Kafka Broker JMX.

## Compatibility

The module has been tested with Kafka 2.1.1, 2.2.2, 3.6.0 and 4.0.0. Other versions are expected to work.

## Usage

The Broker metricset requires [Jolokia](https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-module-jolokia)to fetch JMX metrics. Refer to the link for instructions about how to use Jolokia.
Note that the Jolokia agent is required to be deployed along with the Kafka JVM application. This can be achieved by using the `KAFKA_OPTS` environment variable when starting the Kafka broker application:
```shell
export KAFKA_OPTS=-javaagent:/opt/jolokia-jvm-1.5.0-agent.jar=port=8779,host=localhost
./bin/kafka-server-start.sh ./config/server.properties
```

Then it will be possible to collect the JMX metrics from `localhost:8779`.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-kafka) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2019-10-30T14:22:37.475Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "agent": {
        "ephemeral_id": "f08b3bea-3631-4aaf-b35d-4cef29aeeb06",
        "hostname": "MBP.lan",
        "id": "79dd1677-1bea-4efd-9131-e8ca464eddf0",
        "version": "8.0.0",
        "type": "metricbeat"
    },
    "ecs": {
        "version": "1.2.0"
    },
    "metricset": {
        "name": "broker",
        "period": 10000
    },
    "service": {
        "address": "localhost:8779",
        "type": "kafka"
    },
    "kafka": {
        "broker": {
            "request": {
                "fetch": {
                    "failed_per_second": 0
                },
                "channel": {
                    "queue": {
                        "size": 0
                    }
                },
                "produce": {
                    "failed_per_second": 0
                }
            },
            "replication": {
                "leader_elections": 0,
                "unclean_leader_elections": 0
            },
            "session": {
                "zookeeper": {
                    "expire": 0,
                    "readonly": 0,
                    "sync": 0.00017675970397749868,
                    "disconnect": 0
                }
            },
            "topic": {
                "net": {
                    "bytes_out": 0,
                    "bytes_rejected": 0,
                    "bytes_in": 0
                },
                "messages_in": 0
            }
        }
    },
    "event": {
        "dataset": "kafka.broker",
        "module": "kafka",
        "duration": 7870293
    },
    "host": {
        "name": "MBP.lan",
        "hostname": "MBP.lan",
        "architecture": "x86_64",
        "os": {
            "version": "10.14.6",
            "family": "darwin",
            "name": "Mac OS X",
            "kernel": "18.7.0",
            "build": "18G95",
            "platform": "darwin"
        },
        "id": "883134FF-0EC4-5E1B-9F9E-FD06FB681D84"
    }
}
```