﻿---
title: IBM MQ qmgr metricset
description: This is the qmgr metricset of the IBM MQ module. It collects status information for the Queue Manager. The manager is a system program that is responsible...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-ibmmq-qmgr
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Beta
---

# IBM MQ qmgr metricset
<warning>
  This functionality is in beta and is subject to change. The design and code is less mature than official GA features and is being provided as-is with no warranties. Beta features are not subject to the support SLA of official GA features.
</warning>

This is the `qmgr` metricset of the IBM MQ module. It collects status information for the Queue Manager. The manager is a system program that is responsible for maintaining the queues and ensuring that the messages in the queues reach their destination.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-ibmmq) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2020-01-13T12:58:04.412Z",
    "@metadata": {
        "beat": "metricbeat",
        "type": "_doc",
        "version": "8.0.0"
    },
    "service": {
        "address": "localhost:9157",
        "type": "ibmmq"
    },
    "agent": {
        "version": "8.0.0",
        "type": "metricbeat",
        "ephemeral_id": "752a92a2-5881-49b6-a6c8-a2848dd2a074",
        "hostname": "MacBook-Elastic.local",
        "id": "d662b58a-49c9-4241-aaaf-c5489341138c"
    },
    "ecs": {
        "version": "1.4.0"
    },
    "host": {
        "hostname": "MacBook-Elastic.local",
        "architecture": "x86_64",
        "os": {
            "platform": "darwin",
            "version": "10.14.6",
            "family": "darwin",
            "name": "Mac OS X",
            "kernel": "18.7.0",
            "build": "18G95"
        },
        "name": "MacBook-Elastic.local",
        "id": "24F065F8-4274-521D-8DD5-5D27557E15B4"
    },
    "prometheus": {
        "labels": {
            "qmgr": "QM1",
            "instance": "localhost:9157",
            "job": "ibmmq"
        },
        "metrics": {
            "ibmmq_qmgr_mqctl_total": 0,
            "ibmmq_qmgr_mqcb_total": 0,
            "ibmmq_qmgr_durable_subscription_delete_total": 0,
            "ibmmq_qmgr_non_persistent_message_browse_bytes_total": 0,
            "ibmmq_qmgr_failed_mqset_total": 0,
            "ibmmq_qmgr_failed_subscription_delete_total": 0,
            "ibmmq_qmgr_destructive_get_total": 1772,
            "ibmmq_qmgr_mqput_mqput1_bytes_total": 659084,
            "ibmmq_qmgr_failed_mqsubrq_total": 0,
            "ibmmq_qmgr_topic_put_bytes_total": 473772,
            "ibmmq_qmgr_topic_mqput_mqput1_total": 1761,
            "ibmmq_qmgr_persistent_topic_mqput_mqput1_total": 0,
            "ibmmq_qmgr_failed_mqput_total": 0,
            "ibmmq_qmgr_non_durable_subscription_delete_total": 0,
            "ibmmq_qmgr_non_persistent_message_browse_total": 0,
            "ibmmq_qmgr_expired_message_total": 0,
            "ibmmq_qmgr_non_durable_subscription_create_total": 0,
            "ibmmq_qmgr_non_persistent_message_destructive_get_total": 1772,
            "ibmmq_qmgr_failed_mqcb_total": 0,
            "ibmmq_qmgr_commit_total": 0,
            "ibmmq_qmgr_mqset_total": 0,
            "ibmmq_qmgr_mqsubrq_total": 0,
            "ibmmq_qmgr_mqopen_total": 0,
            "ibmmq_qmgr_durable_subscription_resume_total": 0,
            "ibmmq_qmgr_non_persistent_message_mqput1_total": 0,
            "ibmmq_qmgr_failed_browse_total": 0,
            "ibmmq_qmgr_non_persistent_topic_mqput_mqput1_total": 1761,
            "ibmmq_qmgr_mqconn_mqconnx_total": 0,
            "ibmmq_qmgr_mqstat_total": 0,
            "ibmmq_qmgr_log_logical_written_bytes_total": 0,
            "ibmmq_qmgr_log_physical_written_bytes_total": 0,
            "ibmmq_qmgr_failed_mqput1_total": 0,
            "ibmmq_qmgr_published_to_subscribers_bytes_total": 473772,
            "ibmmq_qmgr_failed_mqclose_total": 0,
            "ibmmq_qmgr_failed_mqget_total": 1481,
            "ibmmq_qmgr_rollback_total": 0,
            "ibmmq_qmgr_failed_subscription_create_alter_resume_total": 0,
            "ibmmq_qmgr_failed_topic_mqput_mqput1_total": 0,
            "ibmmq_qmgr_mqdisc_total": 0,
            "ibmmq_qmgr_failed_mqinq_total": 0,
            "ibmmq_qmgr_non_persistent_message_mqput_total": 1761,
            "ibmmq_qmgr_durable_subscription_create_total": 0,
            "ibmmq_qmgr_failed_mqopen_total": 0,
            "ibmmq_qmgr_failed_mqconn_mqconnx_total": 0,
            "ibmmq_qmgr_persistent_message_put_bytes_total": 0,
            "ibmmq_qmgr_non_persistent_message_get_bytes_total": 663212,
            "ibmmq_qmgr_durable_subscription_alter_total": 0,
            "ibmmq_qmgr_persistent_message_browse_total": 0,
            "ibmmq_qmgr_mqput_mqput1_total": 1761,
            "ibmmq_qmgr_published_to_subscribers_message_total": 1761,
            "ibmmq_qmgr_destructive_get_bytes_total": 663212,
            "ibmmq_qmgr_mqclose_total": 2,
            "ibmmq_qmgr_persistent_message_browse_bytes_total": 0,
            "ibmmq_qmgr_persistent_message_get_bytes_total": 0,
            "ibmmq_qmgr_persistent_message_mqput1_total": 0,
            "ibmmq_qmgr_purged_queue_total": 0,
            "ibmmq_qmgr_persistent_message_destructive_get_total": 0,
            "ibmmq_qmgr_persistent_message_mqput_total": 0,
            "ibmmq_qmgr_mqinq_total": 634,
            "ibmmq_qmgr_non_persistent_message_put_bytes_total": 659084
        }
    },
    "event": {
        "dataset": "ibmmq.qmgr",
        "module": "ibmmq",
        "duration": 4421890
    },
    "metricset": {
        "name": "qmgr",
        "period": 10000
    }
}
```