﻿---
title: HTTP server metricset
description: This is the server metricset of the module http. Events sent to the http endpoint will be put by default under the http.server prefix. To change this...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-http-server
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# HTTP server metricset
This is the server metricset of the module http.
Events sent to the http endpoint will be put by default under the `http.server` prefix. To change this use the `server.paths` config options. In the example below every request to `/foo` will be put under `http.foo`. Also consider using secure settings for the server using TLS/SSL as shown
```yaml
- module: http
  metricsets: ["server"]
  host: "localhost"
  ssl.certificate: "/etc/pki/server/cert.pem"
  ssl.key: "/etc/pki/server/cert.key"
  port: "8080"
  server.paths:
    - path: "/foo"
      namespace: "foo"
```


## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-http) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp":"2016-05-23T08:05:34.853Z",
    "beat":{
        "hostname":"beathost",
        "name":"beathost"
    },
    "metricset":{
        "host":"localhost",
        "module":"http",
        "name":"server",
        "rtt":44269
    },
    "http":{
        "server":{
            "test_metric": 5,
        }
    },
    "type":"metricsets"
}
```