﻿---
title: Golang heap metricset
description: The heap metricset of the Golang module collects the memstats information from the expvar API. For a description of each field in the metricset, see the...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-golang-heap
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Golang heap metricset
The `heap` metricset of the Golang module collects the memstats information from the expvar API.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-golang) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "golang.heap",
        "duration": 115000,
        "module": "golang"
    },
    "golang": {
        "heap": {
            "allocations": {
                "active": 52076544,
                "allocated": 50143344,
                "frees": 23897036,
                "idle": 352256,
                "mallocs": 24213008,
                "objects": 315972,
                "total": 3857953864
            },
            "cmdline": "metricbeat --httpprof :6060 -e",
            "gc": {
                "cpu_fraction": 0.00003865910349307519,
                "next_gc_limit": 52492048,
                "pause": {
                    "avg": {
                        "ns": 466218
                    },
                    "count": 237,
                    "max": {
                        "ns": 4432500
                    },
                    "sum": {
                        "ns": 110493700
                    }
                },
                "total_count": 237,
                "total_pause": {
                    "ns": 110493700
                }
            },
            "system": {
                "obtained": 52428800,
                "released": 0,
                "stack": 983040,
                "total": 59263224
            }
        }
    },
    "metricset": {
        "name": "heap"
    },
    "service": {
        "address": "127.0.0.1:6060",
        "type": "golang"
    }
}
```