﻿---
title: Golang expvar metricset
description: This is the expvar metricset of the Golang module. Go can expose its variables by the expvar API. With this metricset, you can collect all the expvar-exposed...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-golang-expvar
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Golang expvar metricset
This is the `expvar` metricset of the Golang module. Go can expose its variables by the expvar API. With this metricset, you can collect all the expvar-exposed variables.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-golang) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "agent": {
        "hostname": "host.example.com",
        "name": "host.example.com"
    },
    "event": {
        "dataset": "golang.metricbeat",
        "duration": 115000,
        "module": "golang"
    },
    "golang": {
        "metricbeat": {
            "beat.cpu.system.ticks": 166690,
            "beat.cpu.system.time.ms": 166690,
            "beat.cpu.total.ticks": 292490,
            "beat.cpu.total.time.ms": 292490,
            "beat.cpu.total.value": 292490,
            "beat.cpu.user.ticks": 125800,
            "beat.cpu.user.time.ms": 125800,
            "beat.handles.limit.hard": 1048576,
            "beat.handles.limit.soft": 1048576,
            "beat.handles.open": 7,
            "beat.info.ephemeral_id": "ed780330-bb9e-4e3c-aa77-1d943026f757",
            "beat.info.uptime.ms": 87848990,
            "beat.memstats.gc_next": 52327904,
            "beat.memstats.memory_alloc": 26333672,
            "beat.memstats.memory_total": 24294102600,
            "beat.memstats.rss": 87486464,
            "cmdline": "metricbeat --httpprof :6060 -e",
            "libbeat.config.module.running": 0,
            "libbeat.config.module.starts": 0,
            "libbeat.config.module.stops": 0,
            "libbeat.config.reloads": 1,
            "libbeat.output.events.acked": 0,
            "libbeat.output.events.active": 0,
            "libbeat.output.events.batches": 0,
            "libbeat.output.events.dropped": 0,
            "libbeat.output.events.duplicates": 0,
            "libbeat.output.events.failed": 0,
            "libbeat.output.events.total": 0,
            "libbeat.output.read.bytes": 0,
            "libbeat.output.read.errors": 0,
            "libbeat.output.type": "elasticsearch",
            "libbeat.output.write.bytes": 0,
            "libbeat.output.write.errors": 0,
            "libbeat.pipeline.clients": 6,
            "libbeat.pipeline.events.active": 4119,
            "libbeat.pipeline.events.dropped": 0,
            "libbeat.pipeline.events.failed": 0,
            "libbeat.pipeline.events.filtered": 75,
            "libbeat.pipeline.events.published": 4116,
            "libbeat.pipeline.events.retry": 18561,
            "libbeat.pipeline.events.total": 4194,
            "libbeat.pipeline.queue.acked": 0,
            "memstats": {
                "Alloc": 26413208,
                "BuckHashSys": 1844227,
                "BySize": [
                    {
                        "Frees": 0,
                        "Mallocs": 0,
                        "Size": 0
                    },
                    {
                        "Frees": 2260008,
                        "Mallocs": 2260217,
                        "Size": 8
                    },
                    {
                        "Frees": 29751860,
                        "Mallocs": 29792623,
                        "Size": 16
                    },
                    {
                        "Frees": 65505746,
                        "Mallocs": 65517841,
                        "Size": 32
                    },
                    {
                        "Frees": 8254470,
                        "Mallocs": 8318036,
                        "Size": 48
                    },
                    {
                        "Frees": 1030928,
                        "Mallocs": 1031481,
                        "Size": 64
                    },
                    {
                        "Frees": 4787005,
                        "Mallocs": 4788157,
                        "Size": 80
                    },
                    {
                        "Frees": 721021,
                        "Mallocs": 722436,
                        "Size": 96
                    },
                    {
                        "Frees": 3417396,
                        "Mallocs": 3417608,
                        "Size": 112
                    },
                    {
                        "Frees": 1306499,
                        "Mallocs": 1308337,
                        "Size": 128
                    },
                    {
                        "Frees": 416707,
                        "Mallocs": 416725,
                        "Size": 144
                    },
                    {
                        "Frees": 87880,
                        "Mallocs": 88025,
                        "Size": 160
                    },
                    {
                        "Frees": 166727,
                        "Mallocs": 166750,
                        "Size": 176
                    },
                    {
                        "Frees": 4953,
                        "Mallocs": 4963,
                        "Size": 192
                    },
                    {
                        "Frees": 4291495,
                        "Mallocs": 4291665,
                        "Size": 208
                    },
                    {
                        "Frees": 79970,
                        "Mallocs": 79975,
                        "Size": 224
                    },
                    {
                        "Frees": 90,
                        "Mallocs": 109,
                        "Size": 240
                    },
                    {
                        "Frees": 165264,
                        "Mallocs": 165303,
                        "Size": 256
                    },
                    {
                        "Frees": 3687232,
                        "Mallocs": 3747894,
                        "Size": 288
                    },
                    {
                        "Frees": 171547,
                        "Mallocs": 171570,
                        "Size": 320
                    },
                    {
                        "Frees": 242992,
                        "Mallocs": 243050,
                        "Size": 352
                    },
                    {
                        "Frees": 9,
                        "Mallocs": 252,
                        "Size": 384
                    },
                    {
                        "Frees": 256328,
                        "Mallocs": 256350,
                        "Size": 416
                    },
                    {
                        "Frees": 3,
                        "Mallocs": 6,
                        "Size": 448
                    },
                    {
                        "Frees": 1352,
                        "Mallocs": 1357,
                        "Size": 480
                    },
                    {
                        "Frees": 1847711,
                        "Mallocs": 1847744,
                        "Size": 512
                    },
                    {
                        "Frees": 332390,
                        "Mallocs": 333359,
                        "Size": 576
                    },
                    {
                        "Frees": 1248,
                        "Mallocs": 1308,
                        "Size": 640
                    },
                    {
                        "Frees": 317,
                        "Mallocs": 323,
                        "Size": 704
                    },
                    {
                        "Frees": 8,
                        "Mallocs": 8,
                        "Size": 768
                    },
                    {
                        "Frees": 754677,
                        "Mallocs": 754702,
                        "Size": 896
                    },
                    {
                        "Frees": 4269,
                        "Mallocs": 4289,
                        "Size": 1024
                    },
                    {
                        "Frees": 85001,
                        "Mallocs": 85471,
                        "Size": 1152
                    },
                    {
                        "Frees": 250196,
                        "Mallocs": 250219,
                        "Size": 1280
                    },
                    {
                        "Frees": 158,
                        "Mallocs": 163,
                        "Size": 1408
                    },
                    {
                        "Frees": 1829948,
                        "Mallocs": 1829970,
                        "Size": 1536
                    },
                    {
                        "Frees": 503683,
                        "Mallocs": 503710,
                        "Size": 1792
                    },
                    {
                        "Frees": 8355,
                        "Mallocs": 8387,
                        "Size": 2048
                    },
                    {
                        "Frees": 329669,
                        "Mallocs": 329681,
                        "Size": 2304
                    },
                    {
                        "Frees": 72,
                        "Mallocs": 85,
                        "Size": 2688
                    },
                    {
                        "Frees": 158,
                        "Mallocs": 162,
                        "Size": 3072
                    },
                    {
                        "Frees": 3,
                        "Mallocs": 6,
                        "Size": 3200
                    },
                    {
                        "Frees": 2,
                        "Mallocs": 2,
                        "Size": 3456
                    },
                    {
                        "Frees": 1507173,
                        "Mallocs": 1507210,
                        "Size": 4096
                    },
                    {
                        "Frees": 330041,
                        "Mallocs": 330045,
                        "Size": 4864
                    },
                    {
                        "Frees": 517,
                        "Mallocs": 524,
                        "Size": 5376
                    },
                    {
                        "Frees": 81071,
                        "Mallocs": 81079,
                        "Size": 6144
                    },
                    {
                        "Frees": 774,
                        "Mallocs": 774,
                        "Size": 6528
                    },
                    {
                        "Frees": 595,
                        "Mallocs": 595,
                        "Size": 6784
                    },
                    {
                        "Frees": 332,
                        "Mallocs": 332,
                        "Size": 6912
                    },
                    {
                        "Frees": 4708,
                        "Mallocs": 4711,
                        "Size": 8192
                    },
                    {
                        "Frees": 84398,
                        "Mallocs": 84403,
                        "Size": 9472
                    },
                    {
                        "Frees": 902,
                        "Mallocs": 902,
                        "Size": 9728
                    },
                    {
                        "Frees": 69178,
                        "Mallocs": 69179,
                        "Size": 10240
                    },
                    {
                        "Frees": 9,
                        "Mallocs": 12,
                        "Size": 10880
                    },
                    {
                        "Frees": 0,
                        "Mallocs": 0,
                        "Size": 12288
                    },
                    {
                        "Frees": 0,
                        "Mallocs": 0,
                        "Size": 13568
                    },
                    {
                        "Frees": 0,
                        "Mallocs": 8,
                        "Size": 14336
                    },
                    {
                        "Frees": 14,
                        "Mallocs": 14,
                        "Size": 16384
                    },
                    {
                        "Frees": 68815,
                        "Mallocs": 68816,
                        "Size": 18432
                    },
                    {
                        "Frees": 1,
                        "Mallocs": 6,
                        "Size": 19072
                    }
                ],
                "DebugGC": false,
                "EnableGC": true,
                "Frees": 144376316,
                "GCCPUFraction": 0.00003517968356283283,
                "GCSys": 2236416,
                "HeapAlloc": 26413208,
                "HeapIdle": 20283392,
                "HeapInuse": 32210944,
                "HeapObjects": 185078,
                "HeapReleased": 0,
                "HeapSys": 52494336,
                "LastGC": 1551819055172012300,
                "Lookups": 4343732,
                "MCacheInuse": 6944,
                "MCacheSys": 16384,
                "MSpanInuse": 735072,
                "MSpanSys": 884736,
                "Mallocs": 144561394,
                "NextGC": 52327904,
                "NumForcedGC": 0,
                "NumGC": 1087,
                "OtherSys": 804085,
                "PauseEnd": [
                    1551813673522095000,
                    1551813760290548700,
                    1551813847190622500,
                    1551813934200350700,
                    1551814019721081600,
                    1551814106939931400,
                    1551814194787569000,
                    1551814281548459800,
                    1551814368492396500,
                    1551814454527853800,
                    1551814542119804000,
                    1551814629649751800,
                    1551814716395951800,
                    1551814804210529500,
                    1551814890615334400,
                    1551814978246175000,
                    1551815065421775600,
                    1551815153390955800,
                    1551815240459785200,
                    1551815326193419800,
                    1551815413860383500,
                    1551815501772679700,
                    1551815588006216400,
                    1551815675091119800,
                    1551815761793016300,
                    1551815849517625000,
                    1551815935297447000,
                    1551816023119552000,
                    1551816109742317000,
                    1551816196383755000,
                    1551816281910279400,
                    1551816369138096000,
                    1551816456444772000,
                    1551816544463502800,
                    1551816631379998700,
                    1551816717725622500,
                    1551816804412327000,
                    1551816891003677200,
                    1551816978029977300,
                    1551817064869547300,
                    1551817152548437500,
                    1551817239386712000,
                    1551817324881343500,
                    1551817411567689500,
                    1551817497956043500,
                    1551817584365566700,
                    1551817670801177600,
                    1551817757319115300,
                    1551817843753421300,
                    1551817929208882400,
                    1551818015703402000,
                    1551818102313531400,
                    1551818188852253200,
                    1551818274246668000,
                    1551818361273798100,
                    1551818448904188000,
                    1551818535388231400,
                    1551818621922602000,
                    1551818706218998500,
                    1551818792711956200,
                    1551818879595116300,
                    1551818967168253000,
                    1551819055172012300,
                    1551796934883408000,
                    1551797021248211200,
                    1551797107751383300,
                    1551797195222413600,
                    1551797283189797600,
                    1551797369177632300,
                    1551797456524319500,
                    1551797542181850600,
                    1551797630514863400,
                    1551797717763169800,
                    1551797805427074300,
                    1551797891788491500,
                    1551797978864807400,
                    1551798065588669000,
                    1551798151326969600,
                    1551798239535629000,
                    1551798326356424400,
                    1551798413341830100,
                    1551798500461506600,
                    1551798587951146200,
                    1551798673754270200,
                    1551798761447464200,
                    1551798848875440400,
                    1551798936054377200,
                    1551799021834681600,
                    1551799107136041700,
                    1551799193854201900,
                    1551799280921340400,
                    1551799369022987800,
                    1551799455534770000,
                    1551799542074070500,
                    1551799629776769000,
                    1551799716017635800,
                    1551799802785858600,
                    1551799888925246700,
                    1551799975612325400,
                    1551800062708811300,
                    1551800149194365000,
                    1551800235751162000,
                    1551800322693501200,
                    1551800409568045800,
                    1551800496085409000,
                    1551800583059036200,
                    1551800668750943500,
                    1551800756404699000,
                    1551800843149957600,
                    1551800929235447800,
                    1551801015888609500,
                    1551801103210902000,
                    1551801190067903700,
                    1551801278423279000,
                    1551801364164436700,
                    1551801448666044000,
                    1551801534848840400,
                    1551801621663551500,
                    1551801707933268000,
                    1551801794317972500,
                    1551801880680772600,
                    1551801968184599000,
                    1551802054810856000,
                    1551802140391363800,
                    1551802227860272400,
                    1551802313366069000,
                    1551802399985518000,
                    1551802487183356000,
                    1551802574032541200,
                    1551802660872278800,
                    1551802747890506800,
                    1551802835392356000,
                    1551802921037066000,
                    1551803007089838600,
                    1551803095687771000,
                    1551803183049985000,
                    1551803270445534700,
                    1551803356331776000,
                    1551803443692611800,
                    1551803531417985800,
                    1551803618719146200,
                    1551803707210230300,
                    1551803794789760800,
                    1551803882673225200,
                    1551803971459868400,
                    1551804058578875400,
                    1551804145960830200,
                    1551804234254888700,
                    1551804322256049400,
                    1551804410265957400,
                    1551804497226090800,
                    1551804584053460000,
                    1551804671152900600,
                    1551804757897356500,
                    1551804845449297200,
                    1551804932020029700,
                    1551805020157064400,
                    1551805107257989000,
                    1551805195756843000,
                    1551805281765421300,
                    1551805368207391200,
                    1551805455844940000,
                    1551805541505774300,
                    1551805628455398700,
                    1551805715152426800,
                    1551805803356083200,
                    1551805890093024800,
                    1551805976698235600,
                    1551806063405247700,
                    1551806147778785800,
                    1551806235017114000,
                    1551806322267704300,
                    1551806408876106500,
                    1551806495885739000,
                    1551806580581932300,
                    1551806667097105000,
                    1551806752682205000,
                    1551806838448827000,
                    1551806925195549700,
                    1551807011741980200,
                    1551807098721375500,
                    1551807185978657800,
                    1551807273380151800,
                    1551807361262365400,
                    1551807448039038000,
                    1551807533444213800,
                    1551807619848523800,
                    1551807706214843100,
                    1551807791497103600,
                    1551807877970536700,
                    1551807963287305200,
                    1551808049742755300,
                    1551808135095061000,
                    1551808222020724200,
                    1551808307935440000,
                    1551808394622856200,
                    1551808481461249000,
                    1551808568136231700,
                    1551808654787261400,
                    1551808741431564500,
                    1551808828836320000,
                    1551808916029792300,
                    1551809001543323600,
                    1551809087926328800,
                    1551809173839670800,
                    1551809260959386600,
                    1551809347467765800,
                    1551809433043349000,
                    1551809520551369000,
                    1551809607539242500,
                    1551809695671268400,
                    1551809780606221000,
                    1551809867569511400,
                    1551809954451390200,
                    1551810041665356300,
                    1551810128427694800,
                    1551810214973528300,
                    1551810300475295700,
                    1551810386957216000,
                    1551810472868708000,
                    1551810559555873000,
                    1551810645177904400,
                    1551810732307275800,
                    1551810819084136200,
                    1551810904761953800,
                    1551810991401248000,
                    1551811078766944000,
                    1551811166044107300,
                    1551811253602546400,
                    1551811340892026400,
                    1551811426723096300,
                    1551811514132644900,
                    1551811601291153700,
                    1551811688391390000,
                    1551811776222473200,
                    1551811864259342800,
                    1551811951514730800,
                    1551812038325298200,
                    1551812127268150000,
                    1551812214801797600,
                    1551812300436868000,
                    1551812386985713000,
                    1551812473741197800,
                    1551812561146193000,
                    1551812647184361500,
                    1551812733805924400,
                    1551812821584958700,
                    1551812908693565000,
                    1551812996554721800,
                    1551813083661930800,
                    1551813170106764800,
                    1551813254586326300,
                    1551813337054424000,
                    1551813420426787600,
                    1551813505845955300,
                    1551813588899750000
                ],
                "PauseNs": [
                    226100,
                    322500,
                    260100,
                    448500,
                    207500,
                    427400,
                    1550700,
                    214100,
                    1427500,
                    373300,
                    5243700,
                    160200,
                    600500,
                    135800,
                    943800,
                    270300,
                    893500,
                    339600,
                    384000,
                    299900,
                    156900,
                    171100,
                    1642700,
                    514800,
                    165000,
                    249100,
                    1508600,
                    396800,
                    197900,
                    243800,
                    207400,
                    160300,
                    246100,
                    617100,
                    139600,
                    353200,
                    314900,
                    284000,
                    2825600,
                    1395100,
                    276200,
                    271900,
                    108200,
                    362500,
                    193000,
                    271600,
                    181300,
                    307300,
                    257700,
                    232200,
                    562800,
                    480200,
                    332700,
                    751400,
                    363500,
                    219100,
                    2766100,
                    481800,
                    162400,
                    1434800,
                    347600,
                    212800,
                    578900,
                    238000,
                    1019300,
                    213300,
                    239600,
                    188800,
                    1122900,
                    438500,
                    1379200,
                    324700,
                    119200,
                    242100,
                    2210500,
                    197700,
                    234400,
                    2782300,
                    271300,
                    163400,
                    1219300,
                    161600,
                    361900,
                    330400,
                    152600,
                    178200,
                    2522200,
                    468700,
                    240300,
                    225000,
                    874800,
                    778300,
                    350300,
                    289800,
                    222100,
                    264400,
                    350100,
                    159400,
                    151200,
                    2344800,
                    616200,
                    579900,
                    2442800,
                    291800,
                    2999000,
                    484900,
                    238300,
                    219200,
                    614100,
                    316700,
                    1619200,
                    175400,
                    228000,
                    280100,
                    274300,
                    312800,
                    157100,
                    891200,
                    217400,
                    223600,
                    765600,
                    419700,
                    286500,
                    191300,
                    906200,
                    432400,
                    216400,
                    473500,
                    188900,
                    1539000,
                    156300,
                    215100,
                    543400,
                    265700,
                    1357700,
                    115100,
                    358800,
                    245700,
                    247100,
                    254100,
                    578800,
                    1265000,
                    254800,
                    170600,
                    390600,
                    544800,
                    1177300,
                    157300,
                    276100,
                    296500,
                    260100,
                    318200,
                    458400,
                    1839700,
                    745300,
                    351900,
                    1561600,
                    264000,
                    2498100,
                    304500,
                    338300,
                    329300,
                    803600,
                    820400,
                    715800,
                    872500,
                    894800,
                    236000,
                    220700,
                    281900,
                    200800,
                    250200,
                    321800,
                    1590900,
                    1573900,
                    137800,
                    361300,
                    376400,
                    240900,
                    317100,
                    3437200,
                    1722100,
                    257600,
                    189800,
                    292000,
                    223800,
                    1947100,
                    2491900,
                    162300,
                    333200,
                    935100,
                    383500,
                    588700,
                    365200,
                    138100,
                    578300,
                    375000,
                    251500,
                    192100,
                    423400,
                    514900,
                    723400,
                    291900,
                    322100,
                    1684700,
                    137800,
                    193400,
                    2769300,
                    437200,
                    2782300,
                    183700,
                    123700,
                    252800,
                    471500,
                    304500,
                    197900,
                    201200,
                    281900,
                    370500,
                    194300,
                    125100,
                    158300,
                    864300,
                    1291100,
                    315800,
                    209100,
                    277300,
                    748300,
                    186800,
                    250200,
                    294900,
                    206500,
                    2523200,
                    186200,
                    451800,
                    266300,
                    275900,
                    188300,
                    285200,
                    85100,
                    216700,
                    254500,
                    239000,
                    3545400,
                    297300,
                    182400,
                    208900,
                    1895300,
                    372800,
                    160200,
                    215400,
                    1316900,
                    951900,
                    302100,
                    222300,
                    310900
                ],
                "PauseTotalNs": 568650700,
                "StackInuse": 983040,
                "StackSys": 983040,
                "Sys": 59263224,
                "TotalAlloc": 24294182136
            },
            "metricbeat.system.cpu.events": 447,
            "metricbeat.system.cpu.failures": 0,
            "metricbeat.system.cpu.success": 448,
            "metricbeat.system.filesystem.events": 76,
            "metricbeat.system.filesystem.failures": 0,
            "metricbeat.system.filesystem.success": 77,
            "metricbeat.system.fsstat.events": 76,
            "metricbeat.system.fsstat.failures": 0,
            "metricbeat.system.fsstat.success": 77,
            "metricbeat.system.load.events": 447,
            "metricbeat.system.load.failures": 0,
            "metricbeat.system.load.success": 448,
            "metricbeat.system.memory.events": 448,
            "metricbeat.system.memory.failures": 0,
            "metricbeat.system.memory.success": 449,
            "metricbeat.system.network.events": 1792,
            "metricbeat.system.network.failures": 0,
            "metricbeat.system.network.success": 1793,
            "metricbeat.system.process.events": 457,
            "metricbeat.system.process.failures": 0,
            "metricbeat.system.process.success": 458,
            "metricbeat.system.process_summary.events": 447,
            "metricbeat.system.process_summary.failures": 0,
            "metricbeat.system.process_summary.success": 448,
            "metricbeat.system.uptime.events": 7,
            "metricbeat.system.uptime.failures": 0,
            "metricbeat.system.uptime.success": 8,
            "system.cpu.cores": 4,
            "system.load.1": 0.3,
            "system.load.15": 0.24,
            "system.load.5": 0.23,
            "system.load.norm.1": 0.075,
            "system.load.norm.15": 0.06,
            "system.load.norm.5": 0.0575
        }
    },
    "metricset": {
        "name": "expvar"
    },
    "service": {
        "address": "127.0.0.1:6060",
        "type": "golang"
    }
}
```