﻿---
title: Google Cloud Platform storage metricset
description: Storage metricset fetches metrics from Storage in Google Cloud Platform. The storage metricset contains all metrics exported from the GCP Storage Monitoring...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-gcp-storage
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform storage metricset
Storage metricset fetches metrics from [Storage](https://cloud.google.com/storage/) in Google Cloud Platform.
The `storage` metricset contains all metrics exported from the [GCP Storage Monitoring API](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-storage). The field names are aligned to [Beats naming conventions](https://www.elastic.co/docs/extend/beats/event-conventions) with minor modifications to their GCP metrics name counterpart.
You can specify a single region to fetch metrics like `us-central1`. Be aware that GCP Storage does not use zones so `us-central1-a` will return nothing. If no region is specified, metrics are returned from all buckets.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-gcp) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "cloud": {
        "account": {
            "id": "elastic-apm"
        },
        "provider": "gcp"
    },
    "event": {
        "dataset": "gcp.storage",
        "duration": 115000,
        "module": "gcp"
    },
    "gcp": {
        "labels": {
            "metrics": {
                "storage_class": "MULTI_REGIONAL"
            },
            "resource": {
                "bucket_name": "artifacts.elastic-apm.appspot.com",
                "location": "us"
            }
        },
        "storage": {
            "storage": {
                "object_count": {
                    "value": 15
                }
            }
        }
    },
    "metricset": {
        "name": "storage",
        "period": 10000
    },
    "service": {
        "type": "gcp"
    }
}
```