﻿---
title: Google Cloud Platform loadbalancing metricset
description: Load Balancing metricset fetches metrics from Load Balancing in Google Cloud Platform. The loadbalancing metricset contains all metrics exported from...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-gcp-loadbalancing
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform loadbalancing metricset
Load Balancing metricset fetches metrics from [Load Balancing](https://cloud.google.com/load-balancing/) in Google Cloud Platform.
The `loadbalancing` metricset contains all metrics exported from the [Stackdriver API](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-loadbalancing). The field names are aligned to [Beats naming conventions](https://www.elastic.co/docs/extend/beats/event-conventions) with minor modifications to their GCP metrics name counterpart.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-gcp) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "cloud": {
        "account": {
            "id": "elastic-observability"
        },
        "provider": "gcp"
    },
    "event": {
        "dataset": "gcp.loadbalancing",
        "duration": 115000,
        "module": "gcp"
    },
    "gcp": {
        "labels": {
            "metrics": {
                "client_network": "ocp-be-c5kjr-network",
                "client_subnetwork": "ocp-be-c5kjr-worker-subnet",
                "client_zone": "us-central1-a"
            },
            "resource": {
                "backend_name": "ocp-be-c5kjr-master-us-central1-a",
                "backend_scope": "us-central1-a",
                "backend_scope_type": "ZONE",
                "backend_subnetwork_name": "ocp-be-c5kjr-master-subnet",
                "backend_target_name": "ocp-be-c5kjr-api-internal",
                "backend_target_type": "BACKEND_SERVICE",
                "backend_type": "INSTANCE_GROUP",
                "forwarding_rule_name": "ocp-be-c5kjr-api-internal",
                "load_balancer_name": "ocp-be-c5kjr-api-internal",
                "network_name": "ocp-be-c5kjr-network",
                "region": "us-central1"
            }
        },
        "loadbalancing": {
            "l3": {
                "internal": {
                    "egress_packets_count": {
                        "value": 0
                    }
                }
            }
        }
    },
    "metricset": {
        "name": "loadbalancing",
        "period": 10000
    },
    "service": {
        "type": "gcp"
    }
}
```