﻿---
title: Google Cloud Platform gke metricset
description: gke metricset is designed for collecting metrics from Google Kubernetes Engine. Google Cloud Monitoring supports Google Kubernetes Engine metrics, as...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-gcp-gke
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform gke metricset
`gke` metricset is designed for collecting metrics from [Google Kubernetes Engine](https://cloud.google.com/kubernetes-engine). Google Cloud Monitoring supports Google Kubernetes Engine metrics, as listed in [Google Cloud Monitoring Kubernetes metrics](https://cloud.google.com/monitoring/api/metrics_kubernetes).
This metricset collects all GA Kubernetes metrics from Google Cloud Monitoring APIs. It leverages under the hood the `metrics` metricset. The field names are aligned to [Beats naming conventions](https://www.elastic.co/docs/extend/beats/event-conventions) with minor modifications to their GCP metrics name counterpart.
We recommend users to define `period: 1m` for this metricset because in Google Cloud, GKE monitoring metrics are sampled every 60 seconds. Some of the metrics have an ingest delay up to 240 seconds.

## Metricset-specific configuration notes

None

## Configuration example

```yaml
- module: gcp
  metricsets:
    - gke
  project_id: "your project id"
  credentials_file_path: "your JSON credentials file path"
  exclude_labels: false
  period: 1m
```

This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-gcp) section.