﻿---
title: Google Cloud Platform firestore metricset
description: Firestore metricset fetches metrics from Firestore in Google Cloud Platform. The firestore metricset contains all metrics exported from the GCP Firestore...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-gcp-firestore
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform firestore metricset
Firestore metricset fetches metrics from [Firestore](https://cloud.google.com/firestore/) in Google Cloud Platform.
The `firestore` metricset contains all metrics exported from the [GCP Firestore Monitoring API](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-firestore). The field names are aligned to [Beats naming conventions](https://www.elastic.co/docs/extend/beats/event-conventions) with minor modifications to their GCP metrics name counterpart.
You can specify a single region to fetch metrics like `us-central1`. Be aware that GCP Storage does not use zones so `us-central1-a` will return nothing. If no region is specified, metrics are returned from all buckets.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-gcp) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2016-05-23T08:05:34.853Z",
    "cloud": {
        "account": {
            "id": "elastic-apm"
        },
        "provider": "gcp"
    },
    "event": {
        "dataset": "gcp.firestore",
        "duration": 115000,
        "module": "gcp"
    },
    "gcp": {
        "labels": {
            "metrics": {
                "storage_class": "MULTI_REGIONAL"
            },
            "resource": {
                "bucket_name": "artifacts.elastic-apm.appspot.com",
                "location": "us"
            }
        },
        "firestore": {
            "document": {
                "delete_count": {
                    "value": 15
                }
            }
        }
    },
    "metricset": {
        "name": "firestore",
        "period": 10000
    },
    "service": {
        "type": "gcp"
    }
}
```