﻿---
title: Google Cloud Platform dataproc metricset
description: Dataproc metricset fetches metrics from Dataproc in Google Cloud Platform. The dataproc metricset contains all metrics exported from the GCP Dataproc...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-gcp-dataproc
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Google Cloud Platform dataproc metricset
Dataproc metricset fetches metrics from [Dataproc](https://cloud.google.com/dataproc/) in Google Cloud Platform.
The `dataproc` metricset contains all metrics exported from the [GCP Dataproc Monitoring API](https://cloud.google.com/monitoring/api/metrics_gcp#gcp-dataproc). The field names are aligned to [Beats naming conventions](https://www.elastic.co/docs/extend/beats/event-conventions) with minor modifications to their GCP metrics name counterpart.
You can specify a single region to fetch metrics like `us-central1`. Be aware that GCP Storage does not use zones so `us-central1-a` will return nothing. If no region is specified, metrics are returned from all buckets.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-gcp) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2016-05-23T08:05:34.853Z",
    "cloud": {
        "account": {
            "id": "elastic-apm"
        },
        "provider": "gcp"
    },
    "event": {
        "dataset": "gcp.dataproc",
        "duration": 115000,
        "module": "gcp"
    },
    "gcp": {
        "labels": {
            "metrics": {
                "storage_class": "MULTI_REGIONAL"
            },
            "resource": {
                "bucket_name": "artifacts.elastic-apm.appspot.com",
                "location": "us"
            },
            "env": "prod",
            "goog-dataproc-cluster-uuid": "df721ba2-6107-4f54-9da7-44fcef112e78",
            "goog-dataproc-drz-resource-uuid": "cluster-df721ba2-6107-4f54-9da7-44fcef112e78",
            "goog-dataproc-autozone": "enabled",
            "goog-dataproc-cluster-name": "cluster-0cd8",
            "goog-dataproc-location": "us-central1"
        },
        "dataproc": {
            "cluster": {
                "hdfs": {
                    "datanodes": {
                        "value": 15
                    }
                }
            }
        }
    },
    "metricset": {
        "name": "dataproc",
        "period": 10000
    },
    "service": {
        "type": "gcp"
    }
}
```