﻿---
title: Elasticsearch shard metricset
description: The shard metricset interrogates the Cluster State API endpoint to fetch information about all shards. This is a default metricset. If the host module...
url: https://www.elastic.co/docs/reference/beats/metricbeat/metricbeat-metricset-elasticsearch-shard
products:
  - Beats
  - Metricbeat
applies_to:
  - Elastic Stack: Generally available
---

# Elasticsearch shard metricset
The `shard` metricset interrogates the [Cluster State API endpoint](https://www.elastic.co/docs/api/doc/elasticsearch/operation/operation-cluster-state) to fetch information about all shards.
This is a default metricset. If the host module is unconfigured, this metricset is enabled by default.

## Fields

For a description of each field in the metricset, see the [exported fields](https://www.elastic.co/docs/reference/beats/metricbeat/exported-fields-elasticsearch) section.
Here is an example document generated by this metricset:
```json
{
    "@timestamp": "2017-10-12T08:05:34.853Z",
    "elasticsearch": {
        "cluster": {
            "id": "WocBBA0QRma0sGpdQ7vLfQ",
            "name": "docker-cluster",
            "state": {
                "id": "XNIdeSZxQwyItvGfR5fHSw"
            },
            "stats": {
                "state": {
                    "state_uuid": "XNIdeSZxQwyItvGfR5fHSw"
                }
            }
        },
        "index": {
            "name": "pied_piper"
        },
        "node": {
            "id": "f5i3v9hMT_q__q6B9WOo5A"
        },
        "shard": {
            "number": 0,
            "primary": true,
            "relocating_node": {
                "id": null,
                "name": null
            },
            "source_node": {
                "name": "27fb1c2fd783",
                "uuid": "f5i3v9hMT_q__q6B9WOo5A"
            },
            "state": "STARTED"
        }
    },
    "event": {
        "dataset": "elasticsearch.shard",
        "duration": 115000,
        "module": "elasticsearch"
    },
    "metricset": {
        "name": "shard",
        "period": 10000
    },
    "service": {
        "address": "172.19.0.2:9200",
        "type": "elasticsearch"
    }
}
```